/*
 * Copyright 2010 Trustees of the University of Pennsylvania Licensed under the
 * Educational Community License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License. You may
 * obtain a copy of the License at
 *
 * http://www.osedu.org/licenses/ECL-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an "AS IS"
 * BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
import metridoc.dsl.JobManager
import org.springframework.context.ApplicationContext
import org.springframework.context.annotation.AnnotationConfigApplicationContext
import metridoc.dsl.JobBuilder

configureJobBuilder {LinkedHashMap args = null, JobBuilder jobBuilder ->

    def addBeansToServices = {ApplicationContext applicationContext ->
        def services = jobBuilder.services
        applicationContext.beanDefinitionNames.each {String beanName ->
            services[beanName] = applicationContext.getBean(beanName)
        }
    }

    if(args && args.springConfig && args.springConfig instanceof Class) {
        def applicationContext = new AnnotationConfigApplicationContext(args.springConfig)
        addBeansToServices(applicationContext)
    }

    if(args && args.springContext && args.springContext instanceof ApplicationContext) {
        def applicationContext = args.springContext
        addBeansToServices(applicationContext)
    }

    def manager = jobBuilder.jobManager
    manager.metaClass.importSpringConfigs = {Class... classes ->
        def applicationContext = new AnnotationConfigApplicationContext(classes)
        addBeansToServices(applicationContext)
    }
}

