/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsoBufferWrapper {
    ByteBuffer[] parents;
    int activeParent = 0;
    public int readBitsRemaining;
    private byte readBitsBuffer;

    public IsoBufferWrapper(ByteBuffer parent) {
        this.parents = new ByteBuffer[]{parent};
    }

    public IsoBufferWrapper(ByteBuffer[] parents) {
        this.parents = parents;
    }

    public IsoBufferWrapper(List<ByteBuffer> parents) {
        this.parents = parents.toArray(new ByteBuffer[parents.size()]);
    }

    public IsoBufferWrapper(File file) throws IOException {
        long filelength = file.length();
        int sliceSize = 0x8000000;
        RandomAccessFile raf = new RandomAccessFile(file, "r");
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        long i = 0L;
        while (i < filelength) {
            if (filelength - i > (long)sliceSize) {
                MappedByteBuffer bb;
                try {
                    bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                }
                catch (IOException e1) {
                    try {
                        bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                    }
                    catch (IOException e2) {
                        try {
                            bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                        }
                        catch (IOException e3) {
                            bb = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, sliceSize);
                        }
                    }
                }
                buffers.add(bb);
                i += (long)sliceSize;
                continue;
            }
            buffers.add(raf.getChannel().map(FileChannel.MapMode.READ_ONLY, i, filelength - i).slice());
            i += filelength - i;
        }
        this.parents = buffers.toArray(new ByteBuffer[buffers.size()]);
        raf.close();
    }

    public long position() {
        if (this.activeParent >= 0) {
            long pos = 0L;
            for (int i = 0; i < this.activeParent; ++i) {
                pos += (long)this.parents[i].limit();
            }
            return pos += (long)this.parents[this.activeParent].position();
        }
        return this.size();
    }

    public void position(long position) {
        if (position == this.size()) {
            this.activeParent = -1;
        } else {
            int current = 0;
            while (position >= (long)this.parents[current].limit()) {
                position -= (long)this.parents[current++].limit();
            }
            this.parents[current].position((int)position);
            this.activeParent = current;
        }
    }

    public long size() {
        long size = 0L;
        for (ByteBuffer parent : this.parents) {
            size += (long)parent.limit();
        }
        return size;
    }

    public long readUInt64() {
        long result = 0L;
        if ((result += this.readUInt32() << 32) < 0L) {
            throw new RuntimeException("I don't know how to deal with UInt64! long is not sufficient and I don't want to use BigInt");
        }
        return result += this.readUInt32();
    }

    public long readUInt32() {
        long result = 0L;
        result += (long)this.readUInt16() << 16;
        return result += (long)this.readUInt16();
    }

    public int readUInt24() {
        int result = 0;
        result += this.readUInt16() << 8;
        return result += this.readUInt8();
    }

    public int readUInt16() {
        int result = 0;
        result += this.readUInt8() << 8;
        return result += this.readUInt8();
    }

    public int readUInt8() {
        int b = this.read();
        return b < 0 ? b + 256 : b;
    }

    public byte[] read(int byteCount) {
        byte[] result = new byte[byteCount];
        this.read(result);
        return result;
    }

    public long remaining() {
        if (this.activeParent == -1) {
            return 0L;
        }
        long remaining = 0L;
        for (int i = this.activeParent; i < this.parents.length; ++i) {
            remaining += (long)this.parents[i].remaining();
        }
        return remaining;
    }

    public byte read() {
        if (this.parents[this.activeParent].remaining() == 0) {
            if (this.parents.length > this.activeParent + 1) {
                ++this.activeParent;
                this.parents[this.activeParent].rewind();
                return this.read();
            }
            try {
                throw new RuntimeException("No more bytes to read remaining! Make sure position is set correctly after instantiation.");
            }
            catch (RuntimeException e) {
                System.out.println("read beyond buffers!");
                e.printStackTrace();
                return 0;
            }
        }
        return this.parents[this.activeParent].get();
    }

    public int read(byte[] b) {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) {
        if (this.parents[this.activeParent].remaining() >= len) {
            this.parents[this.activeParent].get(b, off, len);
            return len;
        }
        int curRemaining = this.parents[this.activeParent].remaining();
        this.parents[this.activeParent].get(b, off, curRemaining);
        ++this.activeParent;
        this.parents[this.activeParent].rewind();
        return curRemaining + this.read(b, off + curRemaining, len - curRemaining);
    }

    public double readFixedPoint1616() {
        byte[] bytes = this.read(4);
        int result = 0;
        result |= bytes[0] << 24 & 0xFF000000;
        result |= bytes[1] << 16 & 0xFF0000;
        result |= bytes[2] << 8 & 0xFF00;
        return (double)(result |= bytes[3] & 0xFF) / 65536.0;
    }

    public float readFixedPoint88() {
        byte[] bytes = this.read(2);
        int result = 0;
        result = (short)(result | bytes[0] << 8 & 0xFF00);
        result = (short)(result | bytes[1] & 0xFF);
        return (float)result / 256.0f;
    }

    public String readIso639() {
        int bits = this.readUInt16();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < 3; ++i) {
            int c = bits >> (2 - i) * 5 & 0x1F;
            result.append((char)(c + 96));
        }
        return result.toString();
    }

    public String readString() {
        byte read;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = this.read()) != 0) {
            out.write(read);
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM doesn't support UTF-8");
        }
    }

    public String readString(int length) {
        byte[] buffer = new byte[length];
        this.read(buffer);
        try {
            return new String(buffer, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("JVM doesn't support UTF-8");
        }
    }

    public long skip(long n) {
        this.position(this.position() + n);
        return n;
    }

    public ByteBuffer[] getSegment(long startPos, long length) {
        ArrayList<ByteBuffer> segments = new ArrayList<ByteBuffer>();
        this.position(startPos);
        while (length > 0L) {
            ByteBuffer currentSlice = this.parents[this.activeParent].slice();
            if ((long)currentSlice.remaining() >= length) {
                currentSlice.limit((int)length);
                length -= length;
            } else {
                length -= (long)currentSlice.remaining();
                this.parents[++this.activeParent].rewind();
            }
            segments.add(currentSlice);
        }
        return segments.toArray(new ByteBuffer[segments.size()]);
    }

    public long readUInt32BE() {
        long result = 0L;
        result += (long)this.readUInt16BE();
        return result += (long)this.readUInt16BE() << 16;
    }

    public int readUInt16BE() {
        int result = 0;
        result += this.readUInt8();
        return result += this.readUInt8() << 8;
    }

    public int readBits(int i) {
        if (i > 31) {
            throw new IllegalArgumentException("cannot read more than 31 bits");
        }
        int ret = 0;
        while (i > 8) {
            ret |= this.parse8(8) << i - 8;
            i -= 8;
        }
        return ret | this.parse8(i);
    }

    private int parse8(int i) {
        if (this.readBitsRemaining == 0) {
            this.readBitsBuffer = this.read();
            this.readBitsRemaining = 8;
        }
        if (i > this.readBitsRemaining) {
            int resultRemaining = i - this.readBitsRemaining;
            byte buffer = (byte)((byte)(this.readBitsBuffer & (int)(Math.pow(2.0, this.readBitsRemaining) - 1.0)) << resultRemaining);
            this.readBitsBuffer = this.read();
            this.readBitsRemaining = 8 - resultRemaining;
            return buffer | this.readBitsBuffer >>> this.readBitsRemaining & (int)(Math.pow(2.0, resultRemaining) - 1.0);
        }
        this.readBitsRemaining -= i;
        return this.readBitsBuffer >>> this.readBitsRemaining & (int)(Math.pow(2.0, i) - 1.0);
    }

    public int getReadBitsRemaining() {
        return this.readBitsRemaining;
    }
}

