/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.PropertyBoxParserImpl;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.Sample;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsoFile
implements ContainerBox,
Box {
    private List<Box> boxes = new ArrayList<Box>();
    private BoxParser boxParser = new PropertyBoxParserImpl();
    private IsoBufferWrapper originalIso;

    public IsoFile(IsoBufferWrapper originalIso) {
        this.originalIso = originalIso;
    }

    public IsoFile(IsoBufferWrapper originalIso, BoxParser boxParser) {
        this.originalIso = originalIso;
        this.boxParser = boxParser;
    }

    @Override
    public ContainerBox getParent() {
        return null;
    }

    @Override
    public byte[] getType() {
        return new byte[0];
    }

    @Override
    public byte[] getUserType() {
        return new byte[0];
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes.toArray(new Box[this.boxes.size()]);
    }

    public void setBoxes(Box[] boxes) {
        this.boxes = new LinkedList<Box>(Arrays.asList(boxes));
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz.isAssignableFrom(boxe.getClass())) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(Arrays.asList(((ContainerBox)boxe).getBoxes(clazz, recursive)));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    public void addBox(Box b) {
        this.boxes.add(b);
    }

    public void removeBox(Box b) {
        this.boxes.remove(b);
    }

    public void parse() throws IOException {
        boolean done = false;
        Box lastMovieFragmentBox = null;
        while (!done) {
            long sp = this.originalIso.position();
            if (this.originalIso.remaining() >= 8L) {
                Box box = this.boxParser.parseBox(this.originalIso, this, lastMovieFragmentBox);
                if (box != null) {
                    if (box instanceof MovieFragmentBox) {
                        lastMovieFragmentBox = box;
                    }
                    this.boxes.add(box);
                    assert (box.calculateOffset() == sp) : "calculated offset differs from offset in file";
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
    }

    public void parseMdats() throws IOException {
        MediaDataBox[] mdats;
        for (MediaDataBox mdat : mdats = (MediaDataBox[])this.getBoxes(MediaDataBox.class)) {
            mdat.parseTrackChunkSample();
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("IsoFile[");
        if (this.boxes == null) {
            buffer.append("unparsed");
        } else {
            for (int i = 0; i < this.boxes.size(); ++i) {
                if (i > 0) {
                    buffer.append(";");
                }
                buffer.append(this.boxes.get(i).toString());
            }
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static byte[] fourCCtoBytes(String fourCC) {
        byte[] result = new byte[4];
        if (fourCC != null) {
            for (int i = 0; i < Math.min(4, fourCC.length()); ++i) {
                result[i] = (byte)fourCC.charAt(i);
            }
        }
        return result;
    }

    public static String bytesToFourCC(byte[] type) {
        char[] result = "\u0000\u0000\u0000\u0000".toCharArray();
        if (type != null) {
            for (int i = 0; i < Math.min(type.length, 4); ++i) {
                result[i] = (char)type[i];
            }
        }
        return new String(result);
    }

    public static void main(String[] args) {
        System.out.println(IsoFile.bytesToFourCC(new byte[]{109, 118, 101, 120}));
    }

    public static String bytesToFourCC2(byte[] type) {
        byte[] result = new byte[]{0, 0, 0, 0};
        if (type != null) {
            for (int i = 0; i < Math.min(type.length, 4); ++i) {
                result[i] = type[i];
            }
        }
        try {
            return new String(result, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] writeAndCalculateHash(OutputStream os) throws IOException {
        IsoOutputStream isos = new IsoOutputStream(os, true);
        try {
            for (Box box : this.boxes) {
                box.getBox(isos);
            }
        }
        finally {
            isos.flush();
        }
        return isos.getHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBox(IsoOutputStream isos) throws IOException {
        try {
            for (Box box : this.boxes) {
                box.getBox(isos);
            }
        }
        finally {
            isos.flush();
        }
    }

    public List<Sample<? extends TrackMetaDataContainer>> getTrack(long trackId) {
        MediaDataBox[] mdats = (MediaDataBox[])this.getBoxes(MediaDataBox.class);
        LinkedList<Sample<? extends TrackMetaDataContainer>> samplesInTrack = new LinkedList<Sample<? extends TrackMetaDataContainer>>();
        for (MediaDataBox mdat : mdats) {
            List chunks = mdat.getTrack(trackId).getChunks();
            for (Chunk chunk : chunks) {
                samplesInTrack.addAll(chunk.getSamples());
            }
        }
        return samplesInTrack;
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return 0L;
    }

    @Override
    public long getSize() {
        long size = 0L;
        for (Box box : this.boxes) {
            size += box.getSize();
        }
        return size;
    }

    @Override
    public long calculateOffset() {
        return 0L;
    }

    @Override
    public IsoFile getIsoFile() {
        return this;
    }
}

