/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.DynamicChunkOffsetBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.TrackBox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsoFileConvenienceHelper {
    public static void switchToAutomaticChunkOffsetBox(IsoFile isoFile) {
        MovieBox[] movieBoxes;
        for (MovieBox movieBox : movieBoxes = (MovieBox[])isoFile.getBoxes(MovieBox.class)) {
            TrackBox[] trackBoxes;
            for (TrackBox trackBox : trackBoxes = (TrackBox[])movieBox.getBoxes(TrackBox.class)) {
                SampleTableBox sampleTableBox = null;
                for (Box mediaBoxe : trackBox.getBoxes()) {
                    if (!(mediaBoxe instanceof MediaBox)) continue;
                    for (Box mediaInformationBoxe : ((MediaBox)mediaBoxe).getBoxes()) {
                        if (!(mediaInformationBoxe instanceof MediaInformationBox)) continue;
                        for (Box sampleTableBoxe : ((MediaInformationBox)mediaInformationBoxe).getBoxes()) {
                            if (!(sampleTableBoxe instanceof SampleTableBox)) continue;
                            sampleTableBox = (SampleTableBox)sampleTableBoxe;
                        }
                    }
                }
                if (sampleTableBox == null) continue;
                ChunkOffsetBox chunkOffsetBox = sampleTableBox.getChunkOffsetBox();
                if (chunkOffsetBox == null) {
                    System.err.println("Can't switch to AutomaticChunkOffsetBox. SampleTableBox " + sampleTableBox + " doesn't contain a ChunckOffsetBox!");
                    continue;
                }
                sampleTableBox.setChunkOffsetBox(new DynamicChunkOffsetBox(chunkOffsetBox));
            }
        }
    }

    public static Box get(ContainerBox containerBox, String path) {
        String[] parts = path.split("/");
        if (parts.length == 0) {
            return null;
        }
        ArrayList<String> partList = new ArrayList<String>(Arrays.asList(parts));
        if ("".equals(partList.get(0))) {
            partList.remove(0);
        }
        if (partList.size() > 0) {
            List<Box> boxes = Arrays.asList(containerBox.getBoxes());
            return IsoFileConvenienceHelper.get(boxes, partList);
        }
        return null;
    }

    private static Box get(List<Box> boxes, List<String> path) {
        String typeInPath = path.remove(0);
        for (Box box : boxes) {
            if (box instanceof ContainerBox) {
                ContainerBox boxContainer = (ContainerBox)box;
                String type = IsoFile.bytesToFourCC(boxContainer.getType());
                if (!typeInPath.equals(type)) continue;
                List<Box> children = Arrays.asList(boxContainer.getBoxes());
                if (path.size() > 0) {
                    if (children.size() <= 0) continue;
                    return IsoFileConvenienceHelper.get(children, path);
                }
                return box;
            }
            String type = IsoFile.bytesToFourCC(box.getType());
            if (path.size() != 0 || !typeInPath.equals(type)) continue;
            return box;
        }
        return null;
    }
}

