/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso;

import com.coremedia.iso.AbstractBoxParser;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PropertyBoxParserImpl
extends AbstractBoxParser {
    Properties mapping;
    Pattern p = Pattern.compile("(.*)\\((.*?)\\)");

    public PropertyBoxParserImpl() {
        InputStream is = this.getClass().getResourceAsStream("/default.properties");
        this.mapping = new Properties();
        try {
            this.mapping.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PropertyBoxParserImpl(Properties mapping) {
        this.mapping = mapping;
    }

    public AbstractBox createBox(byte[] type, byte[] userType, byte[] parent, Box lastMovieFragmentBox) {
        String constructor = this.mapping.getProperty(IsoFile.bytesToFourCC(parent) + "-" + IsoFile.bytesToFourCC(type));
        if (constructor == null) {
            constructor = this.mapping.getProperty(IsoFile.bytesToFourCC(type));
        }
        if (constructor == null) {
            constructor = this.mapping.getProperty("default");
        }
        if (constructor == null) {
            throw new RuntimeException("No box object found for " + IsoFile.bytesToFourCC(type));
        }
        Matcher m = this.p.matcher(constructor);
        boolean matches = m.matches();
        if (!matches) {
            throw new RuntimeException("Cannot work with that constructor: " + constructor);
        }
        String clazzName = m.group(1);
        String[] param = m.group(2).split(",");
        try {
            if (param[0].trim().length() == 0) {
                param = new String[]{};
            }
            Class<?> clazz = Class.forName(clazzName);
            Class[] constructorArgsClazz = new Class[param.length];
            Object[] constructorArgs = new Object[param.length];
            for (int i = 0; i < param.length; ++i) {
                if ("userType".equals(param[i])) {
                    constructorArgs[i] = userType;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("type".equals(param[i])) {
                    constructorArgs[i] = type;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("parent".equals(param[i])) {
                    constructorArgs[i] = parent;
                    constructorArgsClazz[i] = byte[].class;
                    continue;
                }
                if ("lastMovieFragmentBox".equals(param[i])) {
                    constructorArgs[i] = lastMovieFragmentBox;
                    constructorArgsClazz[i] = MovieFragmentBox.class;
                    continue;
                }
                throw new InternalError("No such param: " + param[i]);
            }
            try {
                Constructor<?> constructorObject = param.length > 0 ? clazz.getConstructor(constructorArgsClazz) : clazz.getConstructor(new Class[0]);
                return (AbstractBox)constructorObject.newInstance(constructorArgs);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

