/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.WriteListener;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public abstract class AbstractBox
implements Box {
    public long offset;
    private List<WriteListener> writeListeners = null;
    private byte[] type;
    private byte[] userType;
    private ContainerBox parent;
    ByteBuffer[] deadBytes = new ByteBuffer[0];

    public void addWriteListener(WriteListener writeListener) {
        if (this.writeListeners == null) {
            this.writeListeners = new LinkedList<WriteListener>();
        }
        this.writeListeners.add(writeListener);
    }

    public long getSize() {
        return this.getContentSize() + this.getHeaderSize() + (long)this.getDeadBytes().length;
    }

    protected long getHeaderSize() {
        return 8 + (this.getContentSize() >= 0x100000000L ? 8 : 0) + (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes("uuid")) ? 16 : 0);
    }

    protected abstract long getContentSize();

    protected AbstractBox(byte[] type) {
        this.type = type;
    }

    public byte[] getType() {
        return this.type;
    }

    public byte[] getUserType() {
        return this.userType;
    }

    public void setUserType(byte[] userType) {
        this.userType = userType;
    }

    public ContainerBox getParent() {
        return this.parent;
    }

    public long getOffset() {
        return this.offset;
    }

    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    public IsoFile getIsoFile() {
        return this.parent.getIsoFile();
    }

    public abstract void parse(IsoBufferWrapper var1, long var2, BoxParser var4, Box var5) throws IOException;

    public abstract String getDisplayName();

    public ByteBuffer[] getDeadBytes() {
        return this.deadBytes;
    }

    public void setDeadBytes(ByteBuffer[] newDeadBytes) {
        this.deadBytes = newDeadBytes;
    }

    public byte[] getHeader() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IsoOutputStream ios = new IsoOutputStream(baos, false);
            if (this.isSmallBox()) {
                ios.writeUInt32((int)this.getSize());
                ios.write(this.getType());
            } else {
                ios.writeUInt32(1L);
                ios.write(this.getType());
                ios.writeUInt64(this.getSize());
            }
            if (Arrays.equals(this.getType(), IsoFile.fourCCtoBytes("uuid"))) {
                ios.write(this.userType);
            }
            assert ((long)baos.size() == this.getHeaderSize());
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private boolean isSmallBox() {
        return this.getSize() < 0x100000000L;
    }

    public void getBox(IsoOutputStream os) throws IOException {
        String uuid;
        long sp = os.getStreamPosition();
        if (this.writeListeners != null) {
            for (WriteListener writeListener : this.writeListeners) {
                writeListener.beforeWrite(sp);
            }
        }
        os.write(this.getHeader());
        this.getContent(os);
        for (ByteBuffer buffer : this.deadBytes) {
            buffer.rewind();
            byte[] bufAsAr = new byte[buffer.limit()];
            buffer.get(bufAsAr);
            os.write(bufAsAr);
        }
        long writtenBytes = os.getStreamPosition() - sp;
        if (this.getUserType() != null && this.getUserType().length == 16) {
            ByteBuffer b = ByteBuffer.wrap(this.getUserType());
            b.order(ByteOrder.BIG_ENDIAN);
            uuid = new UUID(b.getLong(), b.getLong()).toString();
        } else {
            uuid = "--";
        }
        assert (writtenBytes == this.getSize()) : " getHeader + getContent + getDeadBytes (" + writtenBytes + ") of " + IsoFile.bytesToFourCC(this.getType()) + " userType: " + uuid + " doesn't match getSize (" + this.getSize() + ")";
    }

    protected abstract void getContent(IsoOutputStream var1) throws IOException;

    public static int utf8StringLengthInBytes(String utf8) {
        try {
            if (utf8 != null) {
                return utf8.getBytes("UTF-8").length;
            }
            return 0;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public long calculateOffset() {
        Box[] boxes;
        long offsetFromParentBoxStart = this.parent.getNumOfBytesToFirstChild();
        for (Box box : boxes = this.parent.getBoxes()) {
            if (box.equals(this)) {
                return this.parent.calculateOffset() + offsetFromParentBoxStart;
            }
            offsetFromParentBoxStart += box.getSize();
        }
        throw new InternalError("this box is not in the list of its parent's children");
    }
}

