/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContainerBox
extends AbstractBox
implements ContainerBox {
    protected Box[] boxes = new AbstractBox[0];

    @Override
    protected long getContentSize() {
        long contentSize = 0L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public AbstractContainerBox(byte[] type) {
        super(type);
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(Arrays.asList(((ContainerBox)boxe).getBoxes(clazz, recursive)));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    public void addBox(Box b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        listOfBoxes.add(b);
        this.boxes = listOfBoxes.toArray(new Box[listOfBoxes.size()]);
    }

    public void removeBox(Box b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        listOfBoxes.remove(b);
        this.boxes = listOfBoxes.toArray(new Box[listOfBoxes.size()]);
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        LinkedList<Box> boxeList = new LinkedList<Box>();
        while (size > 8L) {
            long sp = in.position();
            Box box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            long parsedBytes = in.position() - sp;
            assert (parsedBytes == box.getSize()) : box + " didn't parse well. number of parsed bytes (" + parsedBytes + ") doesn't match getSize (" + box.getSize() + ")";
            size -= parsedBytes;
            boxeList.add(box);
            this.boxes = boxeList.toArray(new Box[boxeList.size()]);
        }
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Box boxe : this.boxes) {
            boxe.getBox(os);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getClass().getSimpleName()).append("[");
        for (int i = 0; i < this.boxes.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(this.boxes[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return 8L;
    }
}

