/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AlbumBox
extends AbstractFullBox {
    public static final String TYPE = "albm";
    private String language;
    private String albumTitle;
    private int trackNumber;

    public AlbumBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAlbumTitle() {
        return this.albumTitle;
    }

    public int getTrackNumber() {
        return this.trackNumber;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAlbumTitle(String albumTitle) {
        this.albumTitle = albumTitle;
    }

    public void setTrackNumber(int trackNumber) {
        this.trackNumber = trackNumber;
    }

    public String getDisplayName() {
        return "Album Box";
    }

    protected long getContentSize() {
        return 2 + AlbumBox.utf8StringLengthInBytes(this.albumTitle) + 1 + (this.trackNumber == -1 ? 0 : 1);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.albumTitle = in.readString();
        this.trackNumber = (size -= (long)(AlbumBox.utf8StringLengthInBytes(this.albumTitle) + 1 + 6)) > 0L ? in.readUInt8() : -1;
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.albumTitle);
        if (this.trackNumber != -1) {
            isos.writeUInt8(this.trackNumber);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("AlbumBox[language=").append(this.getLanguage()).append(";");
        buffer.append("albumTitle=").append(this.getAlbumTitle());
        if (this.trackNumber >= 0) {
            buffer.append(";trackNumber=").append(this.getTrackNumber());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

