/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AuthorBox
extends AbstractFullBox {
    public static final String TYPE = "auth";
    private String language;
    private String author;

    public AuthorBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getDisplayName() {
        return "Author Box";
    }

    protected long getContentSize() {
        return 2 + AuthorBox.utf8StringLengthInBytes(this.author) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.author = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.author);
    }

    public String toString() {
        return "AuthorBox[language=" + this.getLanguage() + ";author=" + this.getAuthor() + "]";
    }
}

