/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public final class BitRateBox
extends AbstractBox {
    public static final String TYPE = "btrt";
    private long bufferSizeDb;
    private long maxBitrate;
    private long avgBitrate;

    public BitRateBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 12L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.bufferSizeDb = in.readUInt32();
        this.maxBitrate = in.readUInt32();
        this.avgBitrate = in.readUInt32();
    }

    public String getDisplayName() {
        return "Bit Rate Box";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.bufferSizeDb);
        os.writeUInt32(this.maxBitrate);
        os.writeUInt32(this.avgBitrate);
    }
}

