/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class ClassificationBox
extends AbstractFullBox {
    public static final String TYPE = "clsf";
    private String classificationEntity;
    private int classificationTableIndex;
    private String language;
    private String classificationInfo;

    public ClassificationBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getClassificationEntity() {
        return this.classificationEntity;
    }

    public int getClassificationTableIndex() {
        return this.classificationTableIndex;
    }

    public String getClassificationInfo() {
        return this.classificationInfo;
    }

    public void setClassificationEntity(String classificationEntity) {
        this.classificationEntity = classificationEntity;
    }

    public void setClassificationTableIndex(int classificationTableIndex) {
        this.classificationTableIndex = classificationTableIndex;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setClassificationInfo(String classificationInfo) {
        this.classificationInfo = classificationInfo;
    }

    public String getDisplayName() {
        return "Classification Box";
    }

    protected long getContentSize() {
        return 8 + ClassificationBox.utf8StringLengthInBytes(this.classificationInfo) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.classificationEntity = IsoFile.bytesToFourCC(in.read(4));
        this.classificationTableIndex = in.readUInt16();
        this.language = in.readIso639();
        this.classificationInfo = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.classificationEntity));
        isos.writeUInt16(this.classificationTableIndex);
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.classificationInfo);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ClassificationBox[language=").append(this.getLanguage());
        buffer.append("classificationEntity=").append(this.getClassificationEntity());
        buffer.append(";classificationTableIndex=").append(this.getClassificationTableIndex());
        buffer.append(";language=").append(this.getLanguage());
        buffer.append(";classificationInfo=").append(this.getClassificationInfo());
        buffer.append("]");
        return buffer.toString();
    }
}

