/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositionTimeToSample
extends AbstractFullBox {
    public static final String TYPE = "ctts";
    List<Entry> entries = Collections.emptyList();

    public CompositionTimeToSample() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    protected long getContentSize() {
        return 4 + 8 * this.entries.size();
    }

    @Override
    public String getDisplayName() {
        return "Composition Time to Sample Box";
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long numberOfEntries = in.readUInt32();
        assert (numberOfEntries <= Integer.MAX_VALUE) : "Too many entries";
        this.entries = new ArrayList<Entry>((int)numberOfEntries);
        int i = 0;
        while ((long)i < numberOfEntries) {
            Entry e = new Entry(in.readUInt32(), in.readUInt32());
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            os.writeUInt32(entry.getCount());
            os.writeUInt32(entry.getOffset());
        }
    }

    public static class Entry {
        long count;
        long offset;

        public Entry(long count, long offset) {
            this.count = count;
            this.offset = offset;
        }

        public long getCount() {
            return this.count;
        }

        public long getOffset() {
            return this.offset;
        }
    }
}

