/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class CopyrightBox
extends AbstractFullBox {
    public static final String TYPE = "cprt";
    private String language;
    private String copyright;

    public CopyrightBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public String getDisplayName() {
        return "Copyright Box";
    }

    protected long getContentSize() {
        try {
            return 2 + this.copyright.getBytes("UTF-8").length + 1;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.copyright = in.readString();
    }

    public String toString() {
        return "CopyrightBox[language=" + this.getLanguage() + ";copyright=" + this.getCopyright() + "]";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeIso639(this.language);
        os.writeStringZeroTerm(this.copyright);
    }
}

