/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class DataEntryUrnBox
extends AbstractFullBox {
    private String name;
    private String location;
    public static final String TYPE = "urn ";

    public DataEntryUrnBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDisplayName() {
        return "Data Entry URN Box";
    }

    protected long getContentSize() {
        return DataEntryUrnBox.utf8StringLengthInBytes(this.name) + 1 + DataEntryUrnBox.utf8StringLengthInBytes(this.location) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.name = in.readString();
        this.location = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeStringZeroTerm(this.name);
        isos.writeStringZeroTerm(this.location);
    }

    public String toString() {
        return "DataEntryUrlBox[name=" + this.getName() + ";location=" + this.getLocation() + "]";
    }
}

