/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import java.io.IOException;
import java.util.LinkedList;

public class DataReferenceBox
extends FullContainerBox {
    public static final String TYPE = "dref";

    public DataReferenceBox() {
        super(TYPE);
    }

    protected long getContentSize() {
        return super.getContentSize() + 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        Box box;
        this.setVersion(in.readUInt8());
        this.setFlags(in.readUInt24());
        in.readUInt32();
        LinkedList<Box> boxes = new LinkedList<Box>();
        for (long remainingContentSize = size - 8L; remainingContentSize > 0L; remainingContentSize -= box.getSize()) {
            box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            boxes.add(box);
        }
        this.boxes = boxes.toArray(new Box[boxes.size()]);
    }

    public String getDisplayName() {
        return "Data Reference Box";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.getBoxes().length);
        super.getContent(os);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DataReferenceBox[");
        Box[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(boxes[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }
}

