/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.Track;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DynamicChunkOffsetBox
extends ChunkOffsetBox {
    long trackId;

    public DynamicChunkOffsetBox(ChunkOffsetBox chunkOffsetBox) {
        this.trackId = ((TrackBox)chunkOffsetBox.getParent().getParent().getParent().getParent()).getTrackHeaderBox().getTrackId();
        this.setParent(chunkOffsetBox.getParent());
    }

    public long getSize() {
        long contentSize = this.getContentSize();
        return (long)(8 + (contentSize >= 0x100000000L ? 8 : 0) + 4) + contentSize + (long)this.getDeadBytes().length;
    }

    protected long getContentSize() {
        MediaDataBox[] mdats;
        long count = 0L;
        IsoFile isoFile = this.getIsoFile();
        for (MediaDataBox mdat : mdats = (MediaDataBox[])isoFile.getBoxes(MediaDataBox.class)) {
            Track track = mdat.getTrack(this.trackId);
            if (track == null) continue;
            List chunks = track.getChunks();
            count += (long)chunks.size();
        }
        return count * 4L + 4L;
    }

    public long[] getChunkOffsets() {
        IsoFile isoFile = this.getIsoFile();
        MediaDataBox[] mdats = (MediaDataBox[])isoFile.getBoxes(MediaDataBox.class);
        ArrayList<Long> chunkOffsets = new ArrayList<Long>();
        for (MediaDataBox mdat : mdats) {
            long mdatStart = mdat.getOffset();
            Track track = mdat.getTrack(this.trackId);
            if (track == null) continue;
            List chunks = track.getChunks();
            for (Chunk chunk : chunks) {
                chunkOffsets.add(mdatStart + chunk.calculateOffset());
            }
        }
        long[] rc = new long[chunkOffsets.size()];
        for (int i = 0; i < rc.length; ++i) {
            rc[i] = (Long)chunkOffsets.get(i);
        }
        return rc;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        throw new RuntimeException("A DynamicChunkOffsetBox cannot be filled with content by parsing. It needs to be constructed from a StaticChunkOffsetBox");
    }

    public String toString() {
        return "DynamicChunkOffsetBox[entryCount=" + this.getChunkOffsets().length + "]";
    }
}

