/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class ESDescriptorBox
extends AbstractFullBox {
    public static final String TYPE = "esds";
    private int eSDescriptorType;
    private int firstExtendedDescriptorTypeTag;
    private int secondExtendedDescriptorTypeTag;
    private int thirdExtendedDescriptorTypeTag;
    byte[] rest;

    public ESDescriptorBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 4 + this.rest.length;
    }

    public String getDisplayName() {
        return "ES Descriptor Box";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt8(this.eSDescriptorType);
        os.writeUInt8(this.firstExtendedDescriptorTypeTag);
        os.writeUInt8(this.secondExtendedDescriptorTypeTag);
        os.writeUInt8(this.thirdExtendedDescriptorTypeTag);
        os.write(this.rest);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        size -= 4L;
        this.eSDescriptorType = in.readUInt8();
        this.firstExtendedDescriptorTypeTag = in.readUInt8();
        this.secondExtendedDescriptorTypeTag = in.readUInt8();
        this.thirdExtendedDescriptorTypeTag = in.readUInt8();
        this.rest = in.read((int)(size -= 4L));
    }

    public int getESDescriptorType() {
        return this.eSDescriptorType;
    }

    public int getFirstExtendedDescriptorTypeTag() {
        return this.firstExtendedDescriptorTypeTag;
    }

    public int getSecondExtendedDescriptorTypeTag() {
        return this.secondExtendedDescriptorTypeTag;
    }

    public int getThirdExtendedDescriptorTypeTag() {
        return this.thirdExtendedDescriptorTypeTag;
    }
}

