/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class EditListBox
extends AbstractFullBox {
    private long[] segmentDurations;
    private long[] mediaTimes;
    private double[] mediaRates;
    public static final String TYPE = "elst";

    public EditListBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long[] getSegmentDurations() {
        return this.segmentDurations;
    }

    public long[] getMediaTimes() {
        return this.mediaTimes;
    }

    public double[] getMediaRates() {
        return this.mediaRates;
    }

    public String getDisplayName() {
        return "Edit List Box";
    }

    protected long getContentSize() {
        long contentSize = 4L;
        contentSize = this.getVersion() == 1 ? (contentSize += (long)(this.mediaRates.length * 16)) : (contentSize += (long)(this.mediaRates.length * 8));
        return contentSize += (long)(this.mediaRates.length * 4);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.segmentDurations = new long[(int)entryCount];
        this.mediaTimes = new long[(int)entryCount];
        this.mediaRates = new double[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            if (this.getVersion() == 1) {
                this.segmentDurations[i] = in.readUInt64();
                this.mediaTimes[i] = in.readUInt64();
            } else {
                this.segmentDurations[i] = in.readUInt32();
                this.mediaTimes[i] = in.readUInt32();
            }
            this.mediaRates[i] = in.readFixedPoint1616();
            ++i;
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.segmentDurations.length);
        for (int i = 0; i < this.segmentDurations.length; ++i) {
            if (this.getVersion() == 1) {
                isos.writeUInt64(this.segmentDurations[i]);
                isos.writeUInt64(this.mediaTimes[i]);
            } else {
                isos.writeUInt32((int)this.segmentDurations[i]);
                isos.writeUInt32((int)this.mediaTimes[i]);
            }
            isos.writeFixedPont1616(this.mediaRates[i]);
        }
    }

    public String toString() {
        return "EditListBox[entryCount=" + this.segmentDurations.length + "]";
    }
}

