/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class FileTypeBox
extends AbstractBox {
    public static final String TYPE = "ftyp";
    private String majorBrand;
    private long minorVerson;
    private String[] compatibleBrands;

    public FileTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 8 + this.compatibleBrands.length * 4;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.majorBrand = IsoFile.bytesToFourCC(in.read(4));
        this.minorVerson = in.readUInt32();
        int compatibleBrandsCount = (int)((size - 8L) / 4L);
        this.compatibleBrands = new String[compatibleBrandsCount];
        for (int i = 0; i < compatibleBrandsCount; ++i) {
            this.compatibleBrands[i] = IsoFile.bytesToFourCC(in.read(4));
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.majorBrand));
        isos.writeUInt32(this.minorVerson);
        for (String compatibleBrand : this.compatibleBrands) {
            isos.write(IsoFile.fourCCtoBytes(compatibleBrand));
        }
    }

    public String getMajorBrand() {
        return this.majorBrand;
    }

    public void setMajorBrand(String majorBrand) {
        this.majorBrand = majorBrand;
    }

    public void setMinorVerson(int minorVerson) {
        this.minorVerson = minorVerson;
    }

    public long getMinorVerson() {
        return this.minorVerson;
    }

    public String[] getCompatibleBrands() {
        return this.compatibleBrands;
    }

    public void setCompatibleBrands(String[] compatibleBrands) {
        this.compatibleBrands = compatibleBrands;
    }

    public String getDisplayName() {
        return "File Type Box";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("FileTypeBox[");
        result.append("majorBrand=").append(this.getMajorBrand());
        result.append(";");
        result.append("minorVerson=").append(this.getMinorVerson());
        for (String compatibleBrand : this.compatibleBrands) {
            result.append(";");
            result.append("compatibleBrand=").append(compatibleBrand);
        }
        result.append("]");
        return result.toString();
    }
}

