/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class FreeSpaceBox
extends AbstractBox {
    public static final String TYPE = "skip";
    byte[] content;

    protected long getContentSize() {
        return this.content.length;
    }

    public FreeSpaceBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if ((long)((int)size) != size) {
            throw new RuntimeException("The FreeSpaceBox cannot be larger than 2^32 bytes!");
        }
        this.content = in.read((int)size);
    }

    public void setData(byte[] data) {
        this.content = data;
    }

    public byte[] getData() {
        return this.content;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.content);
    }

    public String getDisplayName() {
        return "Free Space Box";
    }

    public String toString() {
        return "FreeSpaceBox[size=" + this.content.length + ";type=" + IsoFile.bytesToFourCC(this.getType()) + "]";
    }
}

