/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FullContainerBox
extends AbstractFullBox
implements ContainerBox {
    protected Box[] boxes = new AbstractBox[0];

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz, boolean recursive) {
        ArrayList<Box> boxesToBeReturned = new ArrayList<Box>(2);
        for (Box boxe : this.boxes) {
            if (clazz == boxe.getClass()) {
                boxesToBeReturned.add(boxe);
            }
            if (!recursive || !(boxe instanceof ContainerBox)) continue;
            boxesToBeReturned.addAll(Arrays.asList(((ContainerBox)boxe).getBoxes(clazz, recursive)));
        }
        return boxesToBeReturned.toArray((Box[])Array.newInstance(clazz, boxesToBeReturned.size()));
    }

    @Override
    protected long getContentSize() {
        long contentSize = 0L;
        for (Box boxe : this.boxes) {
            contentSize += boxe.getSize();
        }
        return contentSize;
    }

    public void addBox(Box b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        listOfBoxes.add(b);
        this.boxes = listOfBoxes.toArray(new AbstractBox[listOfBoxes.size()]);
    }

    public void removeBox(Box b) {
        LinkedList<Box> listOfBoxes = new LinkedList<Box>(Arrays.asList(this.boxes));
        listOfBoxes.remove(b);
        this.boxes = listOfBoxes.toArray(new AbstractBox[listOfBoxes.size()]);
    }

    public FullContainerBox(String type) {
        super(IsoFile.fourCCtoBytes(type));
    }

    @Override
    public Box[] getBoxes() {
        return this.boxes;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.parseHeader(in, size);
        this.parseBoxes(size, in, boxParser, lastMovieFragmentBox);
    }

    protected void parseBoxes(long size, IsoBufferWrapper in, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        Box box;
        LinkedList<Box> boxeList = new LinkedList<Box>();
        for (long remainingContentSize = size - 4L; remainingContentSize > 0L; remainingContentSize -= box.getSize()) {
            box = boxParser.parseBox(in, this, lastMovieFragmentBox);
            boxeList.add(box);
        }
        this.boxes = boxeList.toArray(new Box[boxeList.size()]);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getDisplayName()).append("[");
        Box[] boxes2 = this.getBoxes();
        for (int i = 0; i < boxes2.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(boxes2[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Box boxe : this.boxes) {
            boxe.getBox(os);
        }
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        long sizeOfChildren = 0L;
        for (Box box : this.boxes) {
            sizeOfChildren += box.getSize();
        }
        return this.getSize() - sizeOfChildren;
    }
}

