/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HandlerBox
extends AbstractFullBox {
    public static final String TYPE = "hdlr";
    public static final Map<String, String> readableTypes;
    private String handlerType;
    private String name = "";
    private long a;
    private long b;
    private long c;

    public HandlerBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getHandlerType() {
        return this.handlerType;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHandlerType(String handlerType) {
        this.handlerType = handlerType;
    }

    public String getName() {
        return this.name;
    }

    public String getHumanReadableTrackType() {
        return readableTypes.get(this.handlerType) != null ? readableTypes.get(this.handlerType) : "Unknown Handler Type";
    }

    public String getDisplayName() {
        return "Handler Reference Box";
    }

    protected long getContentSize() {
        return 21 + HandlerBox.utf8StringLengthInBytes(this.name);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        in.readUInt32();
        this.handlerType = IsoFile.bytesToFourCC(in.read(4));
        this.a = in.readUInt32();
        this.b = in.readUInt32();
        this.c = in.readUInt32();
        this.name = in.readString((int)(size - 24L));
        if (this.name.contains("\u0000")) {
            if (this.name.indexOf("\u0000") != this.name.length() - 1) {
                this.deadBytes = new ByteBuffer[1];
                this.deadBytes[0] = ByteBuffer.wrap(this.name.substring(this.name.indexOf(0) + 1).getBytes("UTF-8"));
                this.name = this.name.substring(0, this.name.indexOf(0) + 1);
            }
            this.name = this.name.substring(0, this.name.indexOf(0));
        } else if (this.name.length() > 0) {
            this.name = this.name.substring(1);
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(0L);
        isos.write(IsoFile.fourCCtoBytes(this.handlerType));
        isos.writeUInt32(this.a);
        isos.writeUInt32(this.b);
        isos.writeUInt32(this.c);
        isos.writeStringZeroTerm(this.name);
    }

    public String toString() {
        return "HandlerBox[handlerType=" + this.getHandlerType() + ";name=" + this.getName() + "]";
    }

    static {
        HashMap<String, String> hm = new HashMap<String, String>();
        hm.put("odsm", "ObjectDescriptorStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("crsm", "ClockReferenceStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("sdsm", "SceneDescriptionStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("m7sm", "MPEG7Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("ocsm", "ObjectContentInfoStream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("ipsm", "IPMP Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("mjsm", "MPEG-J Stream - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        hm.put("mdir", "Apple Meta Data iTunes Reader");
        hm.put("mp7b", "MPEG-7 binary XML");
        hm.put("mp7t", "MPEG-7 XML");
        hm.put("vide", "Video Track");
        hm.put("soun", "Sound Track");
        hm.put("hint", "Hint Track");
        hm.put("appl", "Apple specific");
        hm.put("meta", "Timed Metadata track - defined in ISO/IEC JTC1/SC29/WG11 - CODING OF MOVING PICTURES AND AUDIO");
        readableTypes = Collections.unmodifiableMap(hm);
    }
}

