/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.TrackBoxContainer;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import com.coremedia.iso.boxes.fragment.MovieFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.Sample;
import com.coremedia.iso.mdta.SampleImpl;
import com.coremedia.iso.mdta.Track;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaDataBox<T extends TrackMetaDataContainer>
extends AbstractBox {
    public static final String TYPE = "mdat";
    private boolean contentsParsed = false;
    private byte[] deadBytesBefore = new byte[0];
    private long sizeIfNotParsed;
    private long startOffset;
    private Map<Long, Track<T>> tracks = new HashMap<Long, Track<T>>();
    private List<SampleHolder<T>> sampleList = new ArrayList<SampleHolder<T>>();
    private TrackBoxContainer<TrackFragmentBox> movieFragmentBoxBefore;
    private IsoBufferWrapper isoBufferWrapper;

    public MediaDataBox(MovieFragmentBox lastMovieFragmentBox) {
        super(IsoFile.fourCCtoBytes(TYPE));
        this.movieFragmentBoxBefore = lastMovieFragmentBox;
    }

    public boolean isContentsParsed() {
        return this.contentsParsed;
    }

    public byte[] getDeadBytesBefore() {
        return this.deadBytesBefore;
    }

    @Override
    public void getBox(IsoOutputStream os) throws IOException {
        os.write(this.getHeader());
        os.write(this.getDeadBytesBefore());
        this.getContent(os);
        for (ByteBuffer buffer : this.deadBytes) {
            buffer.rewind();
            byte[] bufAsAr = new byte[buffer.limit()];
            buffer.get(bufAsAr);
            os.write(bufAsAr);
        }
    }

    @Override
    public long getSize() {
        long contentSize = this.getContentSize();
        long headerSize = 8 + (contentSize >= 0x100000000L ? 8 : 0);
        return headerSize + contentSize + (long)this.getDeadBytes().length + (long)this.getDeadBytesBefore().length;
    }

    public long getSampleCount() {
        return this.sampleList.size();
    }

    public Sample<T> getSample(int index) {
        return this.sampleList.get(index).getSample();
    }

    public void replaceSample(int index, Sample<?> s) {
        this.sampleList.get(index).setSample(s);
    }

    @Override
    protected long getContentSize() {
        if (this.contentsParsed) {
            long size = 0L;
            for (Track<T> track : this.tracks.values()) {
                size += track.getSize();
            }
            long size2 = 0L;
            for (SampleHolder<T> sample : this.sampleList) {
                size2 += sample.getSample().getSize();
            }
            assert (size == size2);
            return size;
        }
        return this.sizeIfNotParsed;
    }

    public Track<T> getTrack(long trackId) {
        return this.tracks.get(trackId);
    }

    public Map<Long, Track<T>> getTrackMap() {
        return this.tracks;
    }

    public List<Track<T>> getTracks() {
        LinkedList<Track<T>> l = new LinkedList<Track<T>>(this.tracks.values());
        Collections.sort(l);
        return l;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        this.movieFragmentBoxBefore = (MovieFragmentBox)lastMovieFragmentBox;
        this.isoBufferWrapper = in;
        this.startOffset = in.position();
        this.sizeIfNotParsed = size;
        in.skip(size);
    }

    public void parseTrackChunkSample() throws IOException {
        if (!this.contentsParsed) {
            ContainerBox bc = this.getParent();
            while (bc.getParent() != null) {
                bc = bc.getParent();
            }
            TrackBoxContainer[] movieBoxes = (TrackBoxContainer[])bc.getBoxes(MovieBox.class);
            TrackBoxContainer trackBoxContainer = this.movieFragmentBoxBefore == null ? movieBoxes[0] : this.movieFragmentBoxBefore;
            trackBoxContainer.parseMdat(this);
            if (this.sampleList.size() > 0) {
                SampleImpl firstSample = (SampleImpl)this.sampleList.get(0).getSample();
                int bytesToFirstSample = (int)(firstSample.getOffset() - this.startOffset);
                if (bytesToFirstSample < 0) {
                    System.out.println("First sample offset smaller than startOffset of mdat. First sample: " + firstSample);
                    this.deadBytesBefore = new byte[0];
                } else {
                    this.deadBytesBefore = new byte[bytesToFirstSample];
                    this.isoBufferWrapper.position(this.offset + this.getHeaderSize());
                    this.isoBufferWrapper.read(this.deadBytesBefore);
                }
            } else {
                this.deadBytesBefore = new byte[0];
            }
            long endsAt = this.startOffset + (long)this.deadBytesBefore.length;
            long lastOffset = 0L;
            for (SampleHolder<T> sampleHolder : this.sampleList) {
                long newOffset = ((SampleImpl)sampleHolder.getSample()).getOffset();
                assert (newOffset > lastOffset) : "The samples are not in order. Their offsets are not strictly monotonic increasing.";
                assert (endsAt == newOffset) : "There is a gap between two samples: endsAt=" + endsAt + " newOffset=" + newOffset + " sampleIndex=" + this.sampleList.indexOf(sampleHolder);
                endsAt += sampleHolder.getSample().getSize();
            }
            this.contentsParsed = true;
        }
    }

    @Override
    public String getDisplayName() {
        return "Media Data Box";
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.contentsParsed) {
            long sp = os.getStreamPosition();
            for (SampleHolder<T> sample : this.sampleList) {
                sample.getSample().getContent(os);
            }
            assert (this.getContentSize() == os.getStreamPosition() - sp);
        } else {
            ByteBuffer[] segments;
            for (ByteBuffer segment : segments = this.isoBufferWrapper.getSegment(this.startOffset, this.sizeIfNotParsed)) {
                while (segment.remaining() > 1024) {
                    byte[] buf = new byte[1024];
                    segment.get(buf);
                    os.write(buf);
                }
                while (segment.remaining() > 0) {
                    os.write(segment.get());
                }
            }
        }
    }

    public boolean isFragment() {
        return this.movieFragmentBoxBefore != null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MediaDataBox");
        sb.append("{contentsParsed=").append(this.contentsParsed);
        sb.append(", offset=").append(this.getOffset());
        sb.append(", size=").append(this.getSize());
        sb.append(", sampleCount=").append(this.getSampleCount());
        sb.append(", tracks=").append(this.tracks);
        sb.append(", movieFragmentBoxBefore=").append(this.movieFragmentBoxBefore);
        sb.append('}');
        return sb.toString();
    }

    public List<SampleHolder<T>> getSampleList() {
        return this.sampleList;
    }

    public void removeTrack(Track<? extends TrackMetaDataContainer> track) {
        for (Chunk<? extends TrackMetaDataContainer> chunk : track.getChunks()) {
            for (Sample<? extends TrackMetaDataContainer> sample : chunk.getSamples()) {
                if (!sample.getParent().getParentTrack().equals(track)) continue;
                this.sampleList.remove(sample);
            }
        }
    }

    public long getSizeIfNotParsed() {
        return this.sizeIfNotParsed;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SampleHolder<T extends TrackMetaDataContainer> {
        private Sample<T> sample;

        public SampleHolder(Sample<T> sample) {
            this.sample = sample;
        }

        public Sample<T> getSample() {
            return this.sample;
        }

        public void setSample(Sample<T> sample) {
            this.sample = sample;
        }

        public String toString() {
            return "SampleHolder: " + this.sample.toString();
        }
    }
}

