/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieHeaderBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SampleToChunkBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.TrackBoxContainer;
import com.coremedia.iso.boxes.TrackMetaData;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.SampleImpl;
import com.coremedia.iso.mdta.Track;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieBox
extends AbstractContainerBox
implements TrackBoxContainer<TrackBox> {
    public static final String TYPE = "moov";
    private IsoBufferWrapper isoBufferWrapper;

    public MovieBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    public String getDisplayName() {
        return "Movie Box";
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.isoBufferWrapper = in;
    }

    public long[] getChunkOffsets() {
        ArrayList<Long> offsets = new ArrayList<Long>();
        for (Box trackBoxe : this.getBoxes()) {
            long[] chunkOffsets;
            if (!(trackBoxe instanceof TrackBox)) continue;
            TrackBox trackBox = (TrackBox)trackBoxe;
            SampleTableBox sampleTableBox = null;
            for (Box mediaBoxe : trackBox.getBoxes()) {
                if (!(mediaBoxe instanceof MediaBox)) continue;
                for (Box mediaInformationBoxe : ((MediaBox)mediaBoxe).getBoxes()) {
                    if (!(mediaInformationBoxe instanceof MediaInformationBox)) continue;
                    for (Box sampleTableBoxe : ((MediaInformationBox)mediaInformationBoxe).getBoxes()) {
                        if (!(sampleTableBoxe instanceof SampleTableBox)) continue;
                        sampleTableBox = (SampleTableBox)sampleTableBoxe;
                    }
                }
            }
            if (sampleTableBox == null) continue;
            ChunkOffsetBox chunkOffsetBox = sampleTableBox.getChunkOffsetBox();
            if (chunkOffsetBox == null) {
                System.out.println("SampleTableBox " + sampleTableBox + " of TrackBox " + trackBox + " doesn't contain a ChunkOffsetBox!");
                continue;
            }
            for (long chunkOffset : chunkOffsets = chunkOffsetBox.getChunkOffsets()) {
                offsets.add(chunkOffset);
            }
        }
        Collections.sort(offsets);
        long[] returnArray = new long[offsets.size()];
        for (int i = 0; i < returnArray.length; ++i) {
            returnArray[i] = (Long)offsets.get(i);
        }
        return returnArray;
    }

    public long getTrackIdForChunk(long chunkOffset) {
        for (Box trackBoxe : this.getBoxes()) {
            if (!(trackBoxe instanceof TrackBox)) continue;
            TrackBox trackBox = (TrackBox)trackBoxe;
            SampleTableBox sampleTableBox = null;
            for (Box mediaBoxe : trackBox.getBoxes()) {
                if (!(mediaBoxe instanceof MediaBox)) continue;
                for (Box mediaInformationBoxe : ((MediaBox)mediaBoxe).getBoxes()) {
                    if (!(mediaInformationBoxe instanceof MediaInformationBox)) continue;
                    for (Box sampleTableBoxe : ((MediaInformationBox)mediaInformationBoxe).getBoxes()) {
                        if (!(sampleTableBoxe instanceof SampleTableBox)) continue;
                        sampleTableBox = (SampleTableBox)sampleTableBoxe;
                    }
                }
            }
            if (Arrays.binarySearch(sampleTableBox.getChunkOffsetBox().getChunkOffsets(), chunkOffset) < 0) continue;
            return trackBox.getTrackHeaderBox().getTrackId();
        }
        throw new RuntimeException("wrong chunkOffset, the chunk's offset is in no chunk offset box of no track box");
    }

    @Override
    public void parseMdat(MediaDataBox<TrackBox> mdat) {
        long[] chunkOffsets;
        mdat.getTrackMap().clear();
        TreeMap<Long, Track<TrackBox>> trackIdsToTracksWithChunks = new TreeMap<Long, Track<TrackBox>>();
        long[] trackNumbers = this.getTrackNumbers();
        HashMap<Long, Long> trackToSampleCount = new HashMap<Long, Long>(trackNumbers.length);
        HashMap trackToSyncSamples = new HashMap();
        for (long trackNumber : trackNumbers) {
            TrackMetaData<TrackBox> trackMetaData = this.getTrackMetaData(trackNumber);
            trackIdsToTracksWithChunks.put(trackNumber, new Track<TrackBox>(trackNumber, trackMetaData, mdat));
            SyncSampleBox syncSampleBox = trackMetaData.getSyncSampleBox();
            if (syncSampleBox != null) {
                long[] sampleNumbers = syncSampleBox.getSampleNumber();
                ArrayList<Long> sampleNumberList = new ArrayList<Long>(sampleNumbers.length);
                for (long sampleNumber : sampleNumbers) {
                    sampleNumberList.add(sampleNumber);
                }
                trackToSyncSamples.put(trackNumber, sampleNumberList);
            }
            trackToSampleCount.put(trackNumber, 1L);
        }
        for (long chunkOffset : chunkOffsets = this.getChunkOffsets()) {
            if (mdat.getStartOffset() > chunkOffset || chunkOffset > mdat.getStartOffset() + mdat.getSizeIfNotParsed()) {
                System.out.println("Chunk offset " + chunkOffset + " not contained in " + this);
                continue;
            }
            long track = this.getTrackIdForChunk(chunkOffset);
            long[] sampleOffsets = this.getSampleOffsetsForChunk(chunkOffset);
            long[] sampleSizes = this.getSampleSizesForChunk(chunkOffset);
            for (int i = 1; i < sampleSizes.length; ++i) {
                assert (sampleOffsets[i] == sampleSizes[i - 1] + sampleOffsets[i - 1]);
            }
            Track parentTrack = (Track)trackIdsToTracksWithChunks.get(track);
            Chunk<TrackBox> chunk = new Chunk<TrackBox>(parentTrack, mdat, sampleSizes.length);
            parentTrack.addChunk(chunk);
            long trackId = parentTrack.getTrackId();
            mdat.getTrackMap().put(trackId, parentTrack);
            for (int i = 0; i < sampleOffsets.length; ++i) {
                Long currentSample = (Long)trackToSampleCount.get(trackId);
                List syncSamples = (List)trackToSyncSamples.get(trackId);
                boolean syncSample = syncSamples != null && syncSamples.contains(currentSample);
                MediaDataBox.SampleHolder<TrackBox> sh = new MediaDataBox.SampleHolder<TrackBox>(new SampleImpl<TrackBox>(this.isoBufferWrapper, chunkOffset + sampleOffsets[i], sampleSizes[i], chunk, syncSample));
                mdat.getSampleList().add(sh);
                chunk.addSample(sh);
                trackToSampleCount.put(trackId, currentSample + 1L);
            }
        }
    }

    public long[] getSampleSizesForChunk(long chunkOffset) {
        for (Box trackBoxe : this.getBoxes()) {
            if (!(trackBoxe instanceof TrackBox)) continue;
            TrackBox trackBox = (TrackBox)trackBoxe;
            SampleTableBox sampleTableBox = null;
            for (Box mediaBoxe : trackBox.getBoxes()) {
                if (!(mediaBoxe instanceof MediaBox)) continue;
                for (Box mediaInformationBoxe : ((MediaBox)mediaBoxe).getBoxes()) {
                    if (!(mediaInformationBoxe instanceof MediaInformationBox)) continue;
                    for (Box sampleTableBoxe : ((MediaInformationBox)mediaInformationBoxe).getBoxes()) {
                        if (!(sampleTableBoxe instanceof SampleTableBox)) continue;
                        sampleTableBox = (SampleTableBox)sampleTableBoxe;
                    }
                }
            }
            ChunkOffsetBox chunkOffsetBox = sampleTableBox.getChunkOffsetBox();
            long[] chunkOffsets = chunkOffsetBox.getChunkOffsets();
            int chunkNumber = Arrays.binarySearch(chunkOffsets, chunkOffset);
            if (chunkNumber < 0) continue;
            long[] samplesPerChunk = new long[chunkOffsets.length];
            SampleSizeBox sampleSizeBox = sampleTableBox.getSampleSizeBox();
            SampleToChunkBox sampleToChunkBox = sampleTableBox.getSampleToChunkBox();
            LinkedList<SampleToChunkBox.Entry> sampleToChunkEntries = new LinkedList<SampleToChunkBox.Entry>(sampleToChunkBox.getEntries());
            Collections.reverse(sampleToChunkEntries);
            Iterator iterator = sampleToChunkEntries.iterator();
            SampleToChunkBox.Entry currentEntry = (SampleToChunkBox.Entry)iterator.next();
            for (int i = samplesPerChunk.length; i > 1; --i) {
                samplesPerChunk[i - 1] = currentEntry.getSamplesPerChunk();
                if ((long)i != currentEntry.getFirstChunk()) continue;
                currentEntry = (SampleToChunkBox.Entry)iterator.next();
            }
            samplesPerChunk[0] = currentEntry.getSamplesPerChunk();
            int sampleNumberOffset = 0;
            for (int i = 0; i < chunkNumber; ++i) {
                sampleNumberOffset = (int)((long)sampleNumberOffset + samplesPerChunk[i]);
            }
            long noOfSamplesInThisChunk = samplesPerChunk[chunkNumber];
            assert (noOfSamplesInThisChunk <= Integer.MAX_VALUE) : "The parser cannot deal with more than Integer.MAX_VALUE samples in a one chunk";
            long[] returnValue = new long[(int)noOfSamplesInThisChunk];
            int i = 0;
            while ((long)i < samplesPerChunk[chunkNumber]) {
                returnValue[i] = sampleSizeBox.getSampleSizeAtIndex(i + sampleNumberOffset);
                ++i;
            }
            return returnValue;
        }
        throw new RuntimeException("wrong chunkOffset");
    }

    public long[] getSampleOffsetsForChunk(long chunkOffset) {
        long[] sizes = this.getSampleSizesForChunk(chunkOffset);
        long[] offsets = new long[sizes.length];
        for (int i = 1; i < sizes.length; ++i) {
            offsets[i] = offsets[i - 1] + sizes[i - 1];
        }
        return offsets;
    }

    @Override
    public int getTrackCount() {
        return ((TrackBox[])this.getBoxes(TrackBox.class)).length;
    }

    @Override
    public long[] getTrackNumbers() {
        AbstractBox[] trackBoxes = (AbstractBox[])this.getBoxes(TrackBox.class);
        long[] trackNumbers = new long[trackBoxes.length];
        for (int trackCounter = 0; trackCounter < trackBoxes.length; ++trackCounter) {
            AbstractBox trackBoxe = trackBoxes[trackCounter];
            TrackBox trackBox = (TrackBox)trackBoxe;
            trackNumbers[trackCounter] = trackBox.getTrackHeaderBox().getTrackId();
        }
        return trackNumbers;
    }

    @Override
    public TrackMetaData<TrackBox> getTrackMetaData(long trackId) {
        TrackBox[] trackBoxes;
        for (TrackBox trackBox : trackBoxes = (TrackBox[])this.getBoxes(TrackBox.class)) {
            if (trackBox.getTrackHeaderBox().getTrackId() != trackId) continue;
            return new TrackMetaData<TrackBox>(trackId, trackBox);
        }
        throw new RuntimeException("TrackId " + trackId + " not contained in " + this);
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("MovieBox[");
        Box[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(boxes[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public MovieHeaderBox getMovieHeaderBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof MovieHeaderBox)) continue;
            return (MovieHeaderBox)box;
        }
        return null;
    }
}

