/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class MovieHeaderBox
extends AbstractFullBox {
    private long creationTime;
    private long modificationTime;
    private long timescale;
    private long duration;
    private double rate;
    private float volume;
    private long[] matrix;
    private long nextTrackId;
    public static final String TYPE = "mvhd";

    public MovieHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getTimescale() {
        return this.timescale;
    }

    public long getDuration() {
        return this.duration;
    }

    public double getRate() {
        return this.rate;
    }

    public float getVolume() {
        return this.volume;
    }

    public long[] getMatrix() {
        return this.matrix;
    }

    public long getNextTrackId() {
        return this.nextTrackId;
    }

    protected long getContentSize() {
        long contentSize = 0L;
        contentSize = this.getVersion() == 1 ? (contentSize += 28L) : (contentSize += 16L);
        return contentSize += 80L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        int i;
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        if (this.getVersion() == 1) {
            this.creationTime = in.readUInt64();
            this.modificationTime = in.readUInt64();
            this.timescale = in.readUInt32();
            this.duration = in.readUInt64();
        } else {
            this.creationTime = in.readUInt32();
            this.modificationTime = in.readUInt32();
            this.timescale = in.readUInt32();
            this.duration = in.readUInt32();
        }
        this.rate = in.readFixedPoint1616();
        this.volume = in.readFixedPoint88();
        in.readUInt16();
        in.readUInt32();
        in.readUInt32();
        this.matrix = new long[9];
        for (i = 0; i < 9; ++i) {
            this.matrix[i] = in.readUInt32();
        }
        for (i = 0; i < 6; ++i) {
            in.readUInt32();
        }
        this.nextTrackId = in.readUInt32();
    }

    public String getDisplayName() {
        return "Movie Header Box";
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("MovieHeaderBox[");
        result.append("creationTime=").append(this.getCreationTime());
        result.append(";");
        result.append("modificationTime=").append(this.getModificationTime());
        result.append(";");
        result.append("timescale=").append(this.getTimescale());
        result.append(";");
        result.append("duration=").append(this.getDuration());
        result.append(";");
        result.append("rate=").append(this.getRate());
        result.append(";");
        result.append("volume=").append(this.getVolume());
        for (int i = 0; i < this.matrix.length; ++i) {
            result.append(";");
            result.append("matrix").append(i).append("=").append(this.matrix[i]);
        }
        result.append(";");
        result.append("nextTrackId=").append(this.getNextTrackId());
        result.append("]");
        return result.toString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        int i;
        if (this.getVersion() == 1) {
            isos.writeUInt64(this.creationTime);
            isos.writeUInt64(this.modificationTime);
            isos.writeUInt32(this.timescale);
            isos.writeUInt64(this.duration);
        } else {
            isos.writeUInt32((int)this.creationTime);
            isos.writeUInt32((int)this.modificationTime);
            isos.writeUInt32(this.timescale);
            isos.writeUInt32((int)this.duration);
        }
        isos.writeFixedPont1616(this.rate);
        isos.writeFixedPont88(this.volume);
        isos.writeUInt16(0);
        isos.writeUInt32(0L);
        isos.writeUInt32(0L);
        for (i = 0; i < 9; ++i) {
            isos.writeUInt32(this.matrix[i]);
        }
        for (i = 0; i < 6; ++i) {
            isos.writeUInt32(0L);
        }
        isos.writeUInt32(this.nextTrackId);
    }
}

