/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.Arrays;

public class OriginalFormatBox
extends AbstractBox {
    public static final String TYPE = "frma";
    private byte[] dataFormat = new byte[4];

    public OriginalFormatBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public byte[] getDataFormat() {
        return this.dataFormat;
    }

    public String getFourCC() {
        return IsoFile.bytesToFourCC(this.dataFormat);
    }

    public void setDataFormat(byte[] dataFormat) {
        assert (dataFormat.length == 4);
        this.dataFormat = dataFormat;
    }

    public String getDisplayName() {
        return "Original Format Box";
    }

    protected long getContentSize() {
        return 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        assert (size == 4L);
        this.dataFormat[0] = (byte)in.readUInt8();
        this.dataFormat[1] = (byte)in.readUInt8();
        this.dataFormat[2] = (byte)in.readUInt8();
        this.dataFormat[3] = (byte)in.readUInt8();
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.dataFormat);
    }

    public String toString() {
        return "OriginalFormatBox[dataFormat=" + Arrays.toString(this.getDataFormat()) + "]";
    }
}

