/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class RatingBox
extends AbstractFullBox {
    public static final String TYPE = "rtng";
    private String ratingEntity;
    private String ratingCriteria;
    private String language;
    private String ratingInfo;

    public RatingBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public void setRatingEntity(String ratingEntity) {
        this.ratingEntity = ratingEntity;
    }

    public void setRatingCriteria(String ratingCriteria) {
        this.ratingCriteria = ratingCriteria;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setRatingInfo(String ratingInfo) {
        this.ratingInfo = ratingInfo;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getRatingEntity() {
        return this.ratingEntity;
    }

    public String getRatingCriteria() {
        return this.ratingCriteria;
    }

    public String getRatingInfo() {
        return this.ratingInfo;
    }

    public String getDisplayName() {
        return "Rating Box";
    }

    protected long getContentSize() {
        return 10 + RatingBox.utf8StringLengthInBytes(this.ratingInfo) + 1;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.ratingEntity = IsoFile.bytesToFourCC(in.read(4));
        this.ratingCriteria = IsoFile.bytesToFourCC(in.read(4));
        this.language = in.readIso639();
        this.ratingInfo = in.readString();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.write(IsoFile.fourCCtoBytes(this.ratingEntity));
        isos.write(IsoFile.fourCCtoBytes(this.ratingCriteria));
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.ratingInfo);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("RatingBox[language=").append(this.getLanguage());
        buffer.append("ratingEntity=").append(this.getRatingEntity());
        buffer.append(";ratingCriteria=").append(this.getRatingCriteria());
        buffer.append(";language=").append(this.getLanguage());
        buffer.append(";ratingInfo=").append(this.getRatingInfo());
        buffer.append("]");
        return buffer.toString();
    }
}

