/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class SampleSizeBox
extends AbstractFullBox {
    private long sampleSize;
    private long sampleCount;
    private long[] entrySize;
    public static final String TYPE = "stsz";

    public SampleSizeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(long sampleSize) {
        this.sampleSize = sampleSize;
    }

    public long getSampleSizeAtIndex(int index) {
        if (this.sampleSize > 0L) {
            return this.sampleSize;
        }
        return this.entrySize[index];
    }

    public long getSampleCount() {
        return this.sampleCount;
    }

    public long[] getEntrySize() {
        return this.entrySize;
    }

    public void setEntrySize(long[] entrySize) {
        this.entrySize = entrySize;
    }

    public void setEntrySize(int index, long singleSampleSize) {
        if (this.entrySize == null) {
            this.entrySize = new long[(int)this.sampleCount];
            this.sampleSize = 0L;
        }
        this.entrySize[index] = singleSampleSize;
    }

    public String getDisplayName() {
        return "Sample Size Box";
    }

    protected long getContentSize() {
        return 8 + (this.sampleSize == 0L ? this.entrySize.length * 4 : 0);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        assert ((long)((int)size) == size);
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.sampleSize = in.readUInt32();
        this.sampleCount = in.readUInt32();
        if (this.sampleCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE samples!");
        }
        if (this.sampleSize == 0L) {
            this.entrySize = new long[(int)this.sampleCount];
            int i = 0;
            while ((long)i < this.sampleCount) {
                this.entrySize[i] = in.readUInt32();
                ++i;
            }
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.sampleSize);
        isos.writeUInt32(this.sampleCount);
        if (this.sampleSize == 0L) {
            int i = 0;
            while ((long)i < this.sampleCount) {
                isos.writeUInt32(this.entrySize[i]);
                ++i;
            }
        }
    }

    public String toString() {
        return "SampleSizeBox[sampleSize=" + this.getSampleSize() + ";sampleCount=" + this.getSampleCount() + "]";
    }
}

