/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleToChunkBox
extends AbstractFullBox {
    List<Entry> entries = Collections.emptyList();
    public static final String TYPE = "stsc";

    public SampleToChunkBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<Entry> entries) {
        this.entries = entries;
    }

    @Override
    public String getDisplayName() {
        return "Sample to Chunk Box";
    }

    @Override
    protected long getContentSize() {
        return this.entries.size() * 12 + 4;
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.entries = new ArrayList<Entry>((int)entryCount);
        int i = 0;
        while ((long)i < entryCount) {
            Entry e = new Entry();
            e.setFirstChunk(in.readUInt32());
            e.setSamplesPerChunk(in.readUInt32());
            e.setSampleDescriptionIndex(in.readUInt32());
            this.entries.add(e);
            ++i;
        }
    }

    @Override
    protected void getContent(IsoOutputStream isos) throws IOException {
        long l = isos.getStreamPosition();
        isos.writeUInt32(this.entries.size());
        for (Entry entry : this.entries) {
            isos.writeUInt32(entry.getFirstChunk());
            isos.writeUInt32(entry.getSamplesPerChunk());
            isos.writeUInt32(entry.getSampleDescriptionIndex());
        }
        assert (this.getContentSize() == isos.getStreamPosition() - l);
    }

    public String toString() {
        return "SampleToChunkBox[entryCount=" + this.entries.size() + "]";
    }

    public static class Entry {
        long firstChunk;
        long samplesPerChunk;
        long sampleDescriptionIndex;

        public long getFirstChunk() {
            return this.firstChunk;
        }

        public void setFirstChunk(long firstChunk) {
            this.firstChunk = firstChunk;
        }

        public long getSamplesPerChunk() {
            return this.samplesPerChunk;
        }

        public void setSamplesPerChunk(long samplesPerChunk) {
            this.samplesPerChunk = samplesPerChunk;
        }

        public long getSampleDescriptionIndex() {
            return this.sampleDescriptionIndex;
        }

        public void setSampleDescriptionIndex(long sampleDescriptionIndex) {
            this.sampleDescriptionIndex = sampleDescriptionIndex;
        }
    }
}

