/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class SampleToGroupBox
extends AbstractFullBox {
    public static final String TYPE = "sbgp";
    private long groupingType;
    private long entryCount;
    private List<Entry> entries = new ArrayList<Entry>();

    public SampleToGroupBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 8L + this.entryCount * 8L;
    }

    public String getDisplayName() {
        return "Sample to Group Box";
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.groupingType = in.readUInt32();
        this.entryCount = in.readUInt32();
        int i = 0;
        while ((long)i < this.entryCount) {
            Entry entry = new Entry();
            entry.setSampleCount(in.readUInt32());
            entry.setGroupDescriptionIndex(in.readUInt32());
            this.entries.add(entry);
            ++i;
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.groupingType);
        os.writeUInt32(this.entryCount);
        for (Entry entry : this.entries) {
            os.writeUInt32(entry.getSampleCount());
            os.writeUInt32(entry.getGroupDescriptionIndex());
        }
    }

    public static class Entry {
        private long sampleCount;
        private long groupDescriptionIndex;

        public long getSampleCount() {
            return this.sampleCount;
        }

        public void setSampleCount(long sampleCount) {
            this.sampleCount = sampleCount;
        }

        public long getGroupDescriptionIndex() {
            return this.groupDescriptionIndex;
        }

        public void setGroupDescriptionIndex(long groupDescriptionIndex) {
            this.groupDescriptionIndex = groupDescriptionIndex;
        }
    }
}

