/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class SoundMediaHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "smhd";
    private float balance;

    public SoundMediaHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public float getBalance() {
        return this.balance;
    }

    protected long getContentSize() {
        return 4L;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.balance = in.readFixedPoint88();
        in.readUInt16();
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeFixedPont88(this.balance);
        isos.writeUInt16(0);
    }

    public String getDisplayName() {
        return "Sound Media Header Box";
    }

    public String toString() {
        return "SoundMediaHeaderBox[balance=" + this.getBalance() + "]";
    }
}

