/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ChunkOffsetBox;
import java.io.IOException;

public class StaticChunkOffsetBox
extends ChunkOffsetBox {
    public static final String TYPE = "stco";
    private long[] chunkOffsets = new long[0];

    public long[] getChunkOffsets() {
        return this.chunkOffsets;
    }

    protected long getContentSize() {
        return this.getChunkOffsets().length * 4 + 4;
    }

    public void setChunkOffsets(long[] chunkOffsets) {
        this.chunkOffsets = chunkOffsets;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.chunkOffsets = new long[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            this.chunkOffsets[i] = in.readUInt32();
            ++i;
        }
    }
}

