/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class SyncSampleBox
extends AbstractFullBox {
    public static final String TYPE = "stss";
    private long[] sampleNumber;

    public SyncSampleBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public long[] getSampleNumber() {
        return this.sampleNumber;
    }

    public String getDisplayName() {
        return "Sync Sample Box";
    }

    protected long getContentSize() {
        return this.sampleNumber.length * 4 + 4;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        long entryCount = in.readUInt32();
        if (entryCount > Integer.MAX_VALUE) {
            throw new IOException("The parser cannot deal with more than Integer.MAX_VALUE entries!");
        }
        this.sampleNumber = new long[(int)entryCount];
        int i = 0;
        while ((long)i < entryCount) {
            this.sampleNumber[i] = in.readUInt32();
            ++i;
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt32(this.sampleNumber.length);
        for (long aSampleNumber : this.sampleNumber) {
            isos.writeUInt32(aSampleNumber);
        }
    }

    public String toString() {
        return "SyncSampleBox[entryCount=" + this.sampleNumber.length + "]";
    }
}

