/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class TitleBox
extends AbstractFullBox {
    public static final String TYPE = "titl";
    private String language;
    private String title;

    public TitleBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getLanguage() {
        return this.language;
    }

    public String getTitle() {
        return this.title;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDisplayName() {
        return "Title Box";
    }

    protected long getContentSize() {
        try {
            return 3 + this.title.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException();
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeIso639(this.language);
        isos.writeStringZeroTerm(this.title);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.language = in.readIso639();
        this.title = in.readString();
    }

    public String toString() {
        return "TitleBox[language=" + this.getLanguage() + ";title=" + this.getTitle() + "]";
    }
}

