/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.TrackHeaderBox;
import com.coremedia.iso.boxes.TrackMetaDataContainer;
import java.io.IOException;

public class TrackBox
extends AbstractContainerBox
implements TrackMetaDataContainer {
    public static final String TYPE = "trak";
    IsoBufferWrapper isoFile = null;

    public TrackBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getDisplayName() {
        return "Track Box (trackId=" + (this.getTrackHeaderBox() != null ? Long.valueOf(this.getTrackHeaderBox().getTrackId()) : "? (will be parsed later)") + ")";
    }

    public TrackHeaderBox getTrackHeaderBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof TrackHeaderBox)) continue;
            return (TrackHeaderBox)box;
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TrackBox[");
        Box[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                buffer.append(";");
            }
            buffer.append(boxes[i].toString());
        }
        buffer.append("]");
        return buffer.toString();
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.isoFile = in;
    }

    public IsoBufferWrapper getIsoBufferWrapper() {
        return this.isoFile;
    }
}

