/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MediaBox;
import com.coremedia.iso.boxes.MediaInformationBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SampleTableBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TrackBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackMetaData<T> {
    private long trackId;
    private T trackBox;

    public TrackMetaData(long trackId, T trackBox) {
        this.trackId = trackId;
        this.trackBox = trackBox;
    }

    public long getTrackId() {
        return this.trackId;
    }

    public T getTrackBox() {
        return this.trackBox;
    }

    public SampleDescriptionBox getSampleDescriptionBox() {
        if (this.trackBox instanceof TrackBox) {
            SampleTableBox sampleTableBox = ((SampleTableBox[])((MediaInformationBox[])((MediaBox[])((TrackBox)this.trackBox).getBoxes(MediaBox.class, false))[0].getBoxes(MediaInformationBox.class, false))[0].getBoxes(SampleTableBox.class, false))[0];
            return ((SampleDescriptionBox[])sampleTableBox.getBoxes(SampleDescriptionBox.class, false))[0];
        }
        if (this.trackBox instanceof TrackFragmentBox) {
            ContainerBox isoFile = ((TrackFragmentBox)this.trackBox).getParent();
            while (isoFile.getParent() != null) {
                isoFile = isoFile.getParent();
            }
            MovieBox[] movieBoxes = (MovieBox[])isoFile.getBoxes(MovieBox.class);
            if (movieBoxes != null && movieBoxes.length > 0) {
                MovieBox movieBox = movieBoxes[0];
                TrackMetaData<TrackBox> moovTrackMetaData = movieBox.getTrackMetaData(((TrackFragmentBox)this.trackBox).getTrackFragmentHeaderBox().getTrackId());
                return moovTrackMetaData.getSampleDescriptionBox();
            }
            System.out.println("No movie box in file!");
            return null;
        }
        System.out.println("Unsupported trackBox type " + this.trackBox);
        return null;
    }

    public SyncSampleBox getSyncSampleBox() {
        if (this.trackBox instanceof TrackBox) {
            SampleTableBox sampleTableBox = ((SampleTableBox[])((MediaInformationBox[])((MediaBox[])((TrackBox)this.trackBox).getBoxes(MediaBox.class, false))[0].getBoxes(MediaInformationBox.class, false))[0].getBoxes(SampleTableBox.class, false))[0];
            SyncSampleBox[] syncSampleBoxes = (SyncSampleBox[])sampleTableBox.getBoxes(SyncSampleBox.class, false);
            return syncSampleBoxes.length > 0 ? syncSampleBoxes[0] : null;
        }
        if (this.trackBox instanceof TrackFragmentBox) {
            MovieBox[] movieBoxes = (MovieBox[])((TrackFragmentBox)this.trackBox).getIsoFile().getBoxes(MovieBox.class, false);
            if (movieBoxes != null && movieBoxes.length > 0) {
                MovieBox movieBox = movieBoxes[0];
                TrackMetaData<TrackBox> moovTrackMetaData = movieBox.getTrackMetaData(((TrackFragmentBox)this.trackBox).getTrackFragmentHeaderBox().getTrackId());
                return moovTrackMetaData.getSyncSampleBox();
            }
            System.out.println("No movie box in file!");
            return null;
        }
        System.out.println("Unsupported trackBox type " + this.trackBox);
        return null;
    }
}

