/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class TrackReferenceTypeBox
extends AbstractBox {
    public static final String TYPE1 = "hint";
    public static final String TYPE2 = "cdsc";
    private long[] trackIds;

    public TrackReferenceTypeBox(byte[] type) {
        super(type);
    }

    public long[] getTrackIds() {
        return this.trackIds;
    }

    public String getDisplayName() {
        return "Track Reference Type Box";
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        int count = (int)(size / 4L);
        this.trackIds = new long[count];
        for (int i = 0; i < count; ++i) {
            this.trackIds[i] = in.readUInt32();
        }
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        for (long trackId : this.trackIds) {
            os.writeUInt32(trackId);
        }
    }

    protected long getContentSize() {
        return this.trackIds.length * 4;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TrackReferenceTypeBox[type=").append(IsoFile.bytesToFourCC(this.getType()));
        for (int i = 0; i < this.trackIds.length; ++i) {
            buffer.append(";trackId");
            buffer.append(i);
            buffer.append("=");
            buffer.append(this.trackIds[i]);
        }
        buffer.append("]");
        return buffer.toString();
    }
}

