/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class UserBox
extends AbstractBox {
    byte[] content;
    public static final String TYPE = "uuid";

    public UserBox(byte[] userType) {
        super(IsoFile.fourCCtoBytes(TYPE));
        this.setUserType(userType);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        if ((long)((int)size) != size) {
            throw new RuntimeException("The UserBox cannot be larger than 2^32 bytes (Plz enhance the parser!!!)");
        }
        this.content = in.read((int)size);
    }

    public String getDisplayName() {
        return "User Box " + new String(this.getUserType());
    }

    protected long getContentSize() {
        return this.content.length;
    }

    public String toString() {
        return "UserBox[type=" + IsoFile.bytesToFourCC(this.getType()) + ";userType=" + new String(this.getUserType()) + ";contentLength=" + this.content.length + "]";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.content);
    }

    public byte[] getBox() {
        return this.content;
    }
}

