/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class VideoMediaHeaderBox
extends AbstractFullBox {
    private int graphicsmode;
    private int[] opcolor;
    public static final String TYPE = "vmhd";

    public VideoMediaHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public int getGraphicsmode() {
        return this.graphicsmode;
    }

    public int[] getOpcolor() {
        return this.opcolor;
    }

    public String getDisplayName() {
        return "Video Media Header Box";
    }

    protected long getContentSize() {
        return this.opcolor.length * 2 + 2;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.graphicsmode = in.readUInt16();
        this.opcolor = new int[3];
        for (int i = 0; i < 3; ++i) {
            this.opcolor[i] = in.readUInt16();
        }
    }

    protected void getContent(IsoOutputStream isos) throws IOException {
        isos.writeUInt16(this.graphicsmode);
        for (int anOpcolor : this.opcolor) {
            isos.writeUInt16(anOpcolor);
        }
    }

    public String toString() {
        return "VideoMediaHeaderBox[graphicsmode=" + this.getGraphicsmode() + ";opcolor0=" + this.getOpcolor()[0] + ";opcolor1=" + this.getOpcolor()[1] + ";opcolor2=" + this.getOpcolor()[2] + "]";
    }
}

