/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.apple;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.Utf8;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.apple.AppleDataBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAppleMetaDataBox
extends AbstractBox
implements ContainerBox {
    private static Logger LOG = Logger.getLogger(AbstractAppleMetaDataBox.class.getName());
    AppleDataBox appleDataBox = new AppleDataBox();

    @Override
    public Box[] getBoxes() {
        return new AbstractBox[]{this.appleDataBox};
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz) {
        return this.getBoxes(clazz, false);
    }

    @Override
    public <T extends Box> T[] getBoxes(Class<T> clazz, boolean recursive) {
        if (clazz.isAssignableFrom(this.appleDataBox.getClass())) {
            Box[] returnValue = (Box[])Array.newInstance(clazz, 1);
            returnValue[0] = this.appleDataBox;
            return returnValue;
        }
        return null;
    }

    public AbstractAppleMetaDataBox(String type) {
        super(IsoFile.fourCCtoBytes(type));
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        long sp = in.position();
        long dataBoxSize = in.readUInt32();
        String thisShouldBeData = in.readString(4);
        assert ("data".equals(thisShouldBeData));
        this.appleDataBox = new AppleDataBox();
        this.appleDataBox.parse(in, dataBoxSize - 8L, boxParser, lastMovieFragmentBox);
        this.appleDataBox.setParent(this);
        this.appleDataBox.offset = sp;
    }

    @Override
    protected long getContentSize() {
        return this.appleDataBox.getSize();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        this.appleDataBox.getBox(os);
    }

    @Override
    public long getNumOfBytesToFirstChild() {
        return this.getSize() - this.appleDataBox.getSize();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "appleDataBox=" + this.getValue() + '}';
    }

    static long toLong(byte b) {
        return b < 0 ? (long)(b + 256) : (long)b;
    }

    public void setValue(String value) {
        if (this.appleDataBox.getFlags() == 1) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(1);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setContent(Utf8.convert(value));
        } else if (this.appleDataBox.getFlags() == 21) {
            byte[] content;
            block12: {
                content = this.appleDataBox.getContent();
                this.appleDataBox = new AppleDataBox();
                this.appleDataBox.setVersion(0);
                this.appleDataBox.setFlags(21);
                this.appleDataBox.setFourBytes(new byte[4]);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                IsoOutputStream isoOutputStream = new IsoOutputStream(baos);
                try {
                    if (content.length == 1) {
                        isoOutputStream.writeUInt8(Byte.parseByte(value) & 0xFF);
                        break block12;
                    }
                    if (content.length == 2) {
                        isoOutputStream.writeUInt16(Integer.parseInt(value));
                        break block12;
                    }
                    if (content.length == 4) {
                        isoOutputStream.writeUInt32(Long.parseLong(value));
                        break block12;
                    }
                    if (content.length == 8) {
                        isoOutputStream.writeUInt64(Long.parseLong(value));
                        break block12;
                    }
                    throw new Error("The content length within the appleDataBox is neither 1, 2, 4 or 8. I can't handle that!");
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
            this.appleDataBox.setContent(content);
        } else if (this.appleDataBox.getFlags() == 0) {
            this.appleDataBox = new AppleDataBox();
            this.appleDataBox.setVersion(0);
            this.appleDataBox.setFlags(0);
            this.appleDataBox.setFourBytes(new byte[4]);
            this.appleDataBox.setContent(AbstractAppleMetaDataBox.hexStringToByteArray(value));
        } else {
            LOG.warning("Don't know how to handle appleDataBox with flag=" + this.appleDataBox.getFlags());
        }
    }

    public String getValue() {
        if (this.appleDataBox.getFlags() == 1) {
            return Utf8.convert(this.appleDataBox.getContent());
        }
        if (this.appleDataBox.getFlags() == 21) {
            byte[] content = this.appleDataBox.getContent();
            long l = 0L;
            int current = 1;
            int length = content.length;
            for (byte b : content) {
                l += AbstractAppleMetaDataBox.toLong(b) << 8 * (length - current++);
            }
            return "" + l;
        }
        if (this.appleDataBox.getFlags() == 0) {
            return String.format("%x", new BigInteger(this.appleDataBox.getContent()));
        }
        return "unknown";
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }
}

