/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.apple;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public final class AppleDataBox
extends AbstractFullBox {
    public static final String TYPE = "data";
    private byte[] fourBytes = new byte[4];
    private byte[] content;

    private static AppleDataBox getEmpty() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setVersion(0);
        appleDataBox.setFourBytes(new byte[4]);
        return appleDataBox;
    }

    public static AppleDataBox getStringAppleDataBox() {
        AppleDataBox appleDataBox = AppleDataBox.getEmpty();
        appleDataBox.setFlags(1);
        appleDataBox.setContent(new byte[]{0});
        return appleDataBox;
    }

    public static AppleDataBox getUint8AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setContent(new byte[]{0});
        return appleDataBox;
    }

    public static AppleDataBox getUint16AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setContent(new byte[]{0, 0});
        return appleDataBox;
    }

    public static AppleDataBox getUint32AppleDataBox() {
        AppleDataBox appleDataBox = new AppleDataBox();
        appleDataBox.setFlags(21);
        appleDataBox.setContent(new byte[]{0, 0, 0, 0});
        return appleDataBox;
    }

    public AppleDataBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return this.content.length + 4;
    }

    public String getDisplayName() {
        return "iTunes Data Box";
    }

    public void setContent(byte[] content) {
        this.content = new byte[content.length];
        System.arraycopy(content, 0, this.content, 0, content.length);
    }

    public void setFourBytes(byte[] fourBytes) {
        System.arraycopy(fourBytes, 0, this.fourBytes, 0, 4);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.fourBytes[0] = in.read();
        this.fourBytes[1] = in.read();
        this.fourBytes[2] = in.read();
        this.fourBytes[3] = in.read();
        this.content = in.read((int)(size -= 8L));
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.write(this.fourBytes, 0, 4);
        os.write(this.content);
    }

    public byte[] getFourBytes() {
        return this.fourBytes;
    }

    public byte[] getContent() {
        return this.content;
    }
}

