/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.apple;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class AppleDataReferenceBox
extends AbstractFullBox {
    public static final String TYPE = "rdrf";
    private long dataReferenceSize;
    private String dataReferenceType;
    private String dataReference;

    public AppleDataReferenceBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getDisplayName() {
        return "Apple Data Reference Box";
    }

    protected long getContentSize() {
        return 8L + this.dataReferenceSize;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.dataReferenceType = in.readString(4);
        this.dataReferenceSize = in.readUInt32();
        this.dataReference = in.readString((int)this.dataReferenceSize);
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.dataReferenceType);
        os.writeUInt32(this.dataReferenceSize);
        os.writeStringNoTerm(this.dataReference);
    }

    public long getDataReferenceSize() {
        return this.dataReferenceSize;
    }

    public String getDataReferenceType() {
        return this.dataReferenceType;
    }

    public String getDataReference() {
        return this.dataReference;
    }
}

