/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.apple;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public final class AppleLosslessSpecificBox
extends AbstractFullBox {
    public static final String TYPE = "alac";
    private long maxSamplePerFrame;
    private int unknown1;
    private int sampleSize;
    private int historyMult;
    private int initialHistory;
    private int kModifier;
    private int channels;
    private int unknown2;
    private long maxCodedFrameSize;
    private long bitRate;
    private long sampleRate;

    public long getMaxSamplePerFrame() {
        return this.maxSamplePerFrame;
    }

    public void setMaxSamplePerFrame(int maxSamplePerFrame) {
        this.maxSamplePerFrame = maxSamplePerFrame;
    }

    public int getUnknown1() {
        return this.unknown1;
    }

    public void setUnknown1(int unknown1) {
        this.unknown1 = unknown1;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public void setSampleSize(int sampleSize) {
        this.sampleSize = sampleSize;
    }

    public int getHistoryMult() {
        return this.historyMult;
    }

    public void setHistoryMult(int historyMult) {
        this.historyMult = historyMult;
    }

    public int getInitialHistory() {
        return this.initialHistory;
    }

    public void setInitialHistory(int initialHistory) {
        this.initialHistory = initialHistory;
    }

    public int getKModifier() {
        return this.kModifier;
    }

    public void setKModifier(int kModifier) {
        this.kModifier = kModifier;
    }

    public int getChannels() {
        return this.channels;
    }

    public void setChannels(int channels) {
        this.channels = channels;
    }

    public int getUnknown2() {
        return this.unknown2;
    }

    public void setUnknown2(int unknown2) {
        this.unknown2 = unknown2;
    }

    public long getMaxCodedFrameSize() {
        return this.maxCodedFrameSize;
    }

    public void setMaxCodedFrameSize(int maxCodedFrameSize) {
        this.maxCodedFrameSize = maxCodedFrameSize;
    }

    public long getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(int bitRate) {
        this.bitRate = bitRate;
    }

    public long getSampleRate() {
        return this.sampleRate;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.maxSamplePerFrame = in.readUInt32();
        this.unknown1 = in.readUInt8();
        this.sampleSize = in.readUInt8();
        this.historyMult = in.readUInt8();
        this.initialHistory = in.readUInt8();
        this.kModifier = in.readUInt8();
        this.channels = in.readUInt8();
        this.unknown2 = in.readUInt16();
        this.maxCodedFrameSize = in.readUInt32();
        this.bitRate = in.readUInt32();
        this.sampleRate = in.readUInt32();
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.maxSamplePerFrame);
        os.writeUInt8(this.unknown1);
        os.writeUInt8(this.sampleSize);
        os.writeUInt8(this.historyMult);
        os.writeUInt8(this.initialHistory);
        os.writeUInt8(this.kModifier);
        os.writeUInt8(this.channels);
        os.writeUInt16(this.unknown2);
        os.writeUInt32(this.maxCodedFrameSize);
        os.writeUInt32(this.bitRate);
        os.writeUInt32(this.sampleRate);
    }

    public AppleLosslessSpecificBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        return 24L;
    }

    public String getDisplayName() {
        return "Apple Lossless Codec Params";
    }
}

