/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class MovieExtendsHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "mehd";
    private long fragmentDuration;

    public MovieExtendsHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getDisplayName() {
        return "Movie Extends Header Box";
    }

    protected long getContentSize() {
        return this.getVersion() == 1 ? 8L : 4L;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        if (this.getVersion() == 1) {
            os.writeUInt64(this.fragmentDuration);
        } else {
            os.writeUInt32(this.fragmentDuration);
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.fragmentDuration = this.getVersion() == 1 ? in.readUInt64() : in.readUInt32();
    }

    public long getFragmentDuration() {
        return this.fragmentDuration;
    }
}

