/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.AbstractContainerBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.MediaDataBox;
import com.coremedia.iso.boxes.SyncSampleBox;
import com.coremedia.iso.boxes.TrackBoxContainer;
import com.coremedia.iso.boxes.TrackMetaData;
import com.coremedia.iso.boxes.fragment.TrackFragmentBox;
import com.coremedia.iso.boxes.fragment.TrackFragmentHeaderBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import com.coremedia.iso.mdta.Chunk;
import com.coremedia.iso.mdta.SampleImpl;
import com.coremedia.iso.mdta.Track;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MovieFragmentBox
extends AbstractContainerBox
implements TrackBoxContainer<TrackFragmentBox> {
    public static final String TYPE = "moof";
    private IsoBufferWrapper isoBufferWrapper;

    public MovieFragmentBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    public String getDisplayName() {
        return "Movie Fragment Box";
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.isoBufferWrapper = in;
    }

    public List<TrackRunBox> getTrunsWithRealOffsets() {
        TrackFragmentBox[] trackFragmentBoxes;
        ArrayList<TrackRunBox> result = new ArrayList<TrackRunBox>();
        for (TrackFragmentBox trackFragmentBox : trackFragmentBoxes = (TrackFragmentBox[])this.getBoxes(TrackFragmentBox.class, false)) {
            TrackRunBox[] trackRunBoxes;
            TrackFragmentHeaderBox trackFragmentHeaderBox = trackFragmentBox.getTrackFragmentHeaderBox();
            long baseDataOffset = trackFragmentHeaderBox.getBaseDataOffset();
            long cumulatedTrunBoxLength = 0L;
            for (TrackRunBox trackRunBox : trackRunBoxes = (TrackRunBox[])trackFragmentBox.getBoxes(TrackRunBox.class, false)) {
                if (trackRunBox.isDataOffsetPresent()) {
                    trackRunBox.setRealOffset(baseDataOffset + (long)trackRunBox.getDataOffset());
                } else {
                    trackRunBox.setRealOffset(baseDataOffset + cumulatedTrunBoxLength);
                }
                result.add(trackRunBox);
                cumulatedTrunBoxLength += trackRunBox.getSize();
            }
        }
        return result;
    }

    @Override
    public int getTrackCount() {
        return ((TrackFragmentBox[])this.getBoxes(TrackFragmentBox.class, false)).length;
    }

    @Override
    public long[] getTrackNumbers() {
        TrackFragmentBox[] trackBoxes = (TrackFragmentBox[])this.getBoxes(TrackFragmentBox.class, false);
        long[] trackNumbers = new long[trackBoxes.length];
        for (int trackCounter = 0; trackCounter < trackBoxes.length; ++trackCounter) {
            TrackFragmentBox trackBoxe = trackBoxes[trackCounter];
            trackNumbers[trackCounter] = trackBoxe.getTrackFragmentHeaderBox().getTrackId();
        }
        return trackNumbers;
    }

    @Override
    public void parseMdat(MediaDataBox<TrackFragmentBox> mdat) {
        mdat.getTrackMap().clear();
        List<TrackRunBox> truns = this.getTrunsWithRealOffsets();
        TreeMap<Long, Track<TrackFragmentBox>> trackIdsToTracksWithChunks = new TreeMap<Long, Track<TrackFragmentBox>>();
        long[] trackNumbers = this.getTrackNumbers();
        HashMap<Long, Long> trackToSampleCount = new HashMap<Long, Long>(trackNumbers.length);
        HashMap trackToSyncSamples = new HashMap();
        for (long trackNumber : trackNumbers) {
            TrackMetaData<TrackFragmentBox> trackMetaData = this.getTrackMetaData(trackNumber);
            trackIdsToTracksWithChunks.put(trackNumber, new Track<TrackFragmentBox>(trackNumber, trackMetaData, mdat));
            SyncSampleBox syncSampleBox = trackMetaData.getSyncSampleBox();
            if (syncSampleBox != null) {
                long[] sampleNumbers = syncSampleBox.getSampleNumber();
                ArrayList<Long> sampleNumberList = new ArrayList<Long>(sampleNumbers.length);
                for (long sampleNumber : sampleNumbers) {
                    sampleNumberList.add(sampleNumber);
                }
                trackToSyncSamples.put(trackNumber, sampleNumberList);
            }
            trackToSampleCount.put(trackNumber, 1L);
        }
        for (TrackRunBox trackRunBox : truns) {
            TrackFragmentBox trackFragmentBox = (TrackFragmentBox)trackRunBox.getParent();
            long trackId = trackFragmentBox.getTrackFragmentHeaderBox().getTrackId();
            long trunOffset = trackRunBox.getRealOffset();
            if (mdat.getStartOffset() > trunOffset || trunOffset > mdat.getStartOffset() + mdat.getSizeIfNotParsed()) {
                System.out.println("Trun realOffset " + trunOffset + " not contained in " + this);
                continue;
            }
            long[] sampleOffsets = trackRunBox.getSampleOffsets();
            long[] sampleSizes = trackRunBox.getSampleSizes();
            for (int i = 1; i < sampleSizes.length; ++i) {
                assert (sampleOffsets[i] == sampleSizes[i - 1] + sampleOffsets[i - 1]);
            }
            Track parentTrack = (Track)trackIdsToTracksWithChunks.get(trackId);
            Chunk<TrackFragmentBox> chunk = new Chunk<TrackFragmentBox>(parentTrack, mdat, sampleSizes.length);
            parentTrack.addChunk(chunk);
            mdat.getTrackMap().put(parentTrack.getTrackId(), parentTrack);
            for (int i = 0; i < sampleSizes.length; ++i) {
                Long currentSample = (Long)trackToSampleCount.get(trackId);
                List syncSamples = (List)trackToSyncSamples.get(trackId);
                boolean syncSample = syncSamples != null && syncSamples.contains(currentSample);
                MediaDataBox.SampleHolder<TrackFragmentBox> sh = new MediaDataBox.SampleHolder<TrackFragmentBox>(new SampleImpl<TrackFragmentBox>(this.isoBufferWrapper, trunOffset + sampleOffsets[i], sampleSizes[i], chunk, syncSample));
                mdat.getSampleList().add(sh);
                chunk.addSample(sh);
                trackToSampleCount.put(trackId, currentSample + 1L);
            }
        }
    }

    @Override
    public TrackMetaData<TrackFragmentBox> getTrackMetaData(long trackId) {
        TrackFragmentBox[] trackBoxes;
        for (TrackFragmentBox trackFragmentBox : trackBoxes = (TrackFragmentBox[])this.getBoxes(TrackFragmentBox.class, false)) {
            if (trackFragmentBox.getTrackFragmentHeaderBox().getTrackId() != trackId) continue;
            return new TrackMetaData<TrackFragmentBox>(trackId, trackFragmentBox);
        }
        throw new RuntimeException("TrackId " + trackId + " not contained in " + this);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("MovieFragmentBox[");
        Box[] boxes = this.getBoxes();
        for (int i = 0; i < boxes.length; ++i) {
            if (i > 0) {
                builder.append(";");
            }
            builder.append(boxes[i].toString());
        }
        builder.append("]");
        return builder.toString();
    }
}

