/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.ContainerBox;
import com.coremedia.iso.boxes.MovieBox;
import com.coremedia.iso.boxes.SampleSizeBox;
import com.coremedia.iso.boxes.fragment.TrackRunBox;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleDependencyTypeBox
extends AbstractFullBox {
    public static final String TYPE = "sdtp";
    private List<Entry> sampleEntries = new ArrayList<Entry>();

    public SampleDependencyTypeBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    @Override
    public String getDisplayName() {
        return "Independent and Disposable Samples Box";
    }

    @Override
    protected long getContentSize() {
        return this.getSampleCount();
    }

    @Override
    protected void getContent(IsoOutputStream os) throws IOException {
        for (Entry entry : this.sampleEntries) {
            int temp = entry.reserved << 6;
            temp |= entry.sampleDependsOn << 4;
            temp |= entry.sampleIsDependentOn << 2;
            os.write(temp |= entry.sampleHasRedundancy);
        }
    }

    @Override
    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        for (long remainingBytes = size - 4L; remainingBytes > 0L; --remainingBytes) {
            Entry entry = new Entry();
            int temp = in.readUInt8();
            entry.reserved = temp >> 6;
            entry.sampleDependsOn = temp >> 4 & 3;
            entry.sampleIsDependentOn = temp >> 2 & 3;
            entry.sampleHasRedundancy = temp & 3;
            this.sampleEntries.add(entry);
        }
    }

    private long getSampleCount() {
        ContainerBox traf = this.getParent();
        TrackRunBox[] trackRunBoxes = (TrackRunBox[])traf.getBoxes(TrackRunBox.class);
        if (trackRunBoxes.length > 1) {
            for (TrackRunBox trackRunBox : trackRunBoxes) {
                System.out.println("Found (additional) Track Run Box: " + trackRunBox + " in " + traf);
            }
            throw new RuntimeException("More than one Track Fragment Header Box in Track Fragment Box.");
        }
        if (trackRunBoxes.length == 1) {
            return trackRunBoxes[0].getSampleCount();
        }
        System.out.println("Couldn't find Track Run Box. Trying to determine sample count by looking up Sample Size Boxes");
        ContainerBox bc = this.getParent();
        while (bc.getParent() != null) {
            bc = bc.getParent();
        }
        MovieBox[] movieBoxes = (MovieBox[])bc.getBoxes(MovieBox.class, false);
        if (movieBoxes.length == 0) {
            System.out.println("No Movie Box found in " + bc);
            return 0L;
        }
        MovieBox movieBox = movieBoxes[0];
        SampleSizeBox[] sampleSizeBoxes = (SampleSizeBox[])movieBox.getBoxes(SampleSizeBox.class, false);
        long sampleCount = 0L;
        if (sampleSizeBoxes.length > 1) {
            System.out.println("Found more than one Sample Size Box in movie box. Taking first.");
            for (SampleSizeBox sampleSizeBox : sampleSizeBoxes) {
                System.out.println("found Sample Size Box " + sampleSizeBox + " in " + movieBox);
            }
        } else if (sampleSizeBoxes.length > 0) {
            sampleCount = sampleSizeBoxes[0].getSampleCount();
        } else {
            System.out.println("No Sample Size Box found in " + movieBox.getDisplayName());
        }
        return sampleCount;
    }

    public List<Entry> getSampleEntries() {
        return this.sampleEntries;
    }

    public int getSampleEntriesCount() {
        return this.sampleEntries.size();
    }

    public String getSampleEntriesAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry sampleEntry : this.sampleEntries) {
            stringBuilder.append(sampleEntry);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SampleDependencyTypeBox");
        sb.append("{sampleEntries=").append(this.sampleEntries);
        sb.append('}');
        return sb.toString();
    }

    public static class Entry {
        private int reserved;
        private int sampleDependsOn;
        private int sampleIsDependentOn;
        private int sampleHasRedundancy;

        public int getReserved() {
            return this.reserved;
        }

        public int getSampleDependsOn() {
            return this.sampleDependsOn;
        }

        public int getSampleIsDependentOn() {
            return this.sampleIsDependentOn;
        }

        public int getSampleHasRedundancy() {
            return this.sampleHasRedundancy;
        }

        public String toString() {
            return "Entry{reserved=" + this.reserved + ", sampleDependsOn=" + this.sampleDependsOn + ", sampleIsDependentOn=" + this.sampleIsDependentOn + ", sampleHasRedundancy=" + this.sampleHasRedundancy + '}';
        }
    }
}

