/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.fragment;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractBox;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.fragment.SampleFlags;
import java.io.IOException;

public class TrackFragmentHeaderBox
extends AbstractFullBox {
    public static final String TYPE = "tfhd";
    private long trackId;
    private long baseDataOffset;
    private long sampleDescriptionIndex;
    private long defaultSampleDuration;
    private long defaultSampleSize;
    private SampleFlags defaultSampleFlags;
    private boolean durationIsEmpty;

    public TrackFragmentHeaderBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getDisplayName() {
        return "Track Fragment Header Box";
    }

    protected long getContentSize() {
        long size = 4L;
        if ((this.getFlags() & 1) == 1) {
            size += 8L;
        }
        if ((this.getFlags() & 2) == 2) {
            size += 4L;
        }
        if ((this.getFlags() & 8) == 8) {
            size += 4L;
        }
        if ((this.getFlags() & 0x10) == 16) {
            size += 4L;
        }
        if ((this.getFlags() & 0x20) == 32) {
            size += 4L;
        }
        return size;
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt32(this.trackId);
        if ((this.getFlags() & 1) == 1) {
            os.writeUInt64(this.baseDataOffset);
        }
        if ((this.getFlags() & 2) == 2) {
            os.writeUInt32(this.sampleDescriptionIndex);
        }
        if ((this.getFlags() & 8) == 8) {
            os.writeUInt32(this.defaultSampleDuration);
        }
        if ((this.getFlags() & 0x10) == 16) {
            os.writeUInt32(this.defaultSampleSize);
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags.getContent(os);
        }
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.trackId = in.readUInt32();
        if ((this.getFlags() & 1) == 1) {
            this.baseDataOffset = in.readUInt64();
        }
        if ((this.getFlags() & 2) == 2) {
            this.sampleDescriptionIndex = in.readUInt32();
        }
        if ((this.getFlags() & 8) == 8) {
            this.defaultSampleDuration = in.readUInt32();
        }
        if ((this.getFlags() & 0x10) == 16) {
            this.defaultSampleSize = in.readUInt32();
        }
        if ((this.getFlags() & 0x20) == 32) {
            this.defaultSampleFlags = new SampleFlags(in.readUInt32());
        }
        if ((this.getFlags() & 0x10000) == 65536) {
            this.durationIsEmpty = true;
        }
    }

    public long getTrackId() {
        return this.trackId;
    }

    public long getBaseDataOffset() {
        if ((this.getFlags() & 1) == 1) {
            return this.baseDataOffset;
        }
        return ((AbstractBox)((Object)this.getParent().getParent())).getOffset();
    }

    public long getSampleDescriptionIndex() {
        return this.sampleDescriptionIndex;
    }

    public long getDefaultSampleDuration() {
        return this.defaultSampleDuration;
    }

    public long getDefaultSampleSize() {
        return this.defaultSampleSize;
    }

    public String getDefaultSampleFlags() {
        return this.defaultSampleFlags.toString();
    }

    public boolean isDurationIsEmpty() {
        return this.durationIsEmpty;
    }

    public void setTrackId(long trackId) {
        this.trackId = trackId;
    }

    public void setBaseDataOffset(long baseDataOffset) {
        this.setFlags(this.getFlags() | 1);
        this.baseDataOffset = baseDataOffset;
    }

    public void setSampleDescriptionIndex(long sampleDescriptionIndex) {
        this.setFlags(this.getFlags() | 2);
        this.sampleDescriptionIndex = sampleDescriptionIndex;
    }

    public void setDefaultSampleDuration(long defaultSampleDuration) {
        this.setFlags(this.getFlags() | 8);
        this.defaultSampleDuration = defaultSampleDuration;
    }

    public void setDefaultSampleSize(long defaultSampleSize) {
        this.setFlags(this.getFlags() | 0x10);
        this.defaultSampleSize = defaultSampleSize;
    }

    public void setDefaultSampleFlags(SampleFlags defaultSampleFlags) {
        this.setFlags(this.getFlags() | 0x20);
        this.defaultSampleFlags = defaultSampleFlags;
    }

    public void setDurationIsEmpty(boolean durationIsEmpty) {
        this.setFlags(this.getFlags() | 0x10000);
        this.durationIsEmpty = durationIsEmpty;
    }
}

