/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.FullContainerBox;
import com.coremedia.iso.boxes.odf.OmaDrmContentObjectBox;
import com.coremedia.iso.boxes.odf.OmaDrmDiscreteHeadersBox;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class OmaDrmContainerBox
extends FullContainerBox {
    public static final String TYPE = "odrm";

    protected long getHeaderSize() {
        return 20L;
    }

    public byte[] getHeader() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IsoOutputStream ios = new IsoOutputStream(baos);
            ios.writeUInt32(1L);
            ios.write(this.getType());
            ios.writeUInt64(this.getSize());
            ios.writeUInt8(this.getVersion());
            ios.writeUInt24(this.getFlags());
            assert ((long)baos.size() == this.getHeaderSize());
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public OmaDrmContainerBox() {
        super(TYPE);
    }

    public String getDisplayName() {
        return "OMA DRM Container Box";
    }

    public OmaDrmDiscreteHeadersBox getOmaDrmDiscreteHeadersBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof OmaDrmDiscreteHeadersBox)) continue;
            return (OmaDrmDiscreteHeadersBox)box;
        }
        return null;
    }

    public OmaDrmContentObjectBox getOmaDrmContentObjectBox() {
        for (Box box : this.boxes) {
            if (!(box instanceof OmaDrmContentObjectBox)) continue;
            return (OmaDrmContentObjectBox)box;
        }
        return null;
    }
}

