/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class OmaDrmContentIdBox
extends AbstractFullBox {
    public static final String TYPE = "ccid";
    String contentId;

    public OmaDrmContentIdBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    protected long getContentSize() {
        try {
            return 2 + this.contentId.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new Error(e);
        }
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public String getDisplayName() {
        return "Content Id Sub Box";
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeUInt16(this.contentId.getBytes("UTF-8").length);
        os.write(this.contentId.getBytes("UTF-8"));
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        int length = in.readUInt16();
        this.contentId = in.readString(length);
    }
}

