/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes.odf;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.IsoBufferWrapper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoOutputStream;
import com.coremedia.iso.boxes.AbstractFullBox;
import com.coremedia.iso.boxes.Box;
import java.io.IOException;

public class OmaDrmCoverUriBox
extends AbstractFullBox {
    public static final String TYPE = "cvru";
    private String coverUri;

    public OmaDrmCoverUriBox() {
        super(IsoFile.fourCCtoBytes(TYPE));
    }

    public String getCoverUri() {
        return this.coverUri;
    }

    public String getDisplayName() {
        return "Cover URI Box";
    }

    protected long getContentSize() {
        return OmaDrmCoverUriBox.utf8StringLengthInBytes(this.coverUri);
    }

    public void parse(IsoBufferWrapper in, long size, BoxParser boxParser, Box lastMovieFragmentBox) throws IOException {
        super.parse(in, size, boxParser, lastMovieFragmentBox);
        this.coverUri = in.readString((int)(size - 4L));
    }

    protected void getContent(IsoOutputStream os) throws IOException {
        os.writeStringNoTerm(this.coverUri);
    }

    public String toString() {
        return "OmaDrmCoverUriBox[coverUri=" + this.getCoverUri() + "]";
    }
}

